import time
import numpy as np

# numpy działa w obrębie pypy
# random_sample zastępuje uniform (korzysta z interwału otwartego w połowie)
# np.sum działa inaczej niż sum
# http://morepypy.blogspot.co.uk/2013/11/numpy-status-update.html
# http://buildbot.pypy.org/numpy-status/latest.html


def y_is_in_circle(x, y):
    """Sprawdzenie, czy współrzędna x,y znajduje się w obrębie promienia koła jednostkowego"""
    return x * x + y * y <= 1.0


nbr_samples = int(1e7)
print "Użycie:", nbr_samples
xs = np.random.random_sample(size=nbr_samples)
ys = np.random.random_sample(size=nbr_samples)
t1 = time.time()
nbr_in_circle = y_is_in_circle(xs, ys)
print "Czas trwania: {} s".format(time.time() - t1)
print nbr_in_circle[:10]
#nbr_in_circle_sum = float(sum(nbr_in_circle))
nbr_in_circle_sum = np.sum(nbr_in_circle, dtype=np.int64)
print nbr_in_circle_sum

pi_estimate = float(nbr_in_circle_sum) / nbr_samples * 4
print pi_estimate
print np.pi
