import timeit


def binary_search(needle, haystack):
    # Zmienne imin i imax przechowują aktualnie rozpatrywane granice
    # tablicy haystack. Na początku są to granice tablicy haystack, które powoli
    # zbiegają się, otaczając wartości parametru needle.
    imin, imax = 0, len(haystack)
    while True:
        if imin >= imax:
            return -1
        midpoint = (imin + imax) // 2
        if haystack[midpoint] > needle:
            imax = midpoint
        elif haystack[midpoint] < needle:
            imin = midpoint + 1
        else:
            return midpoint


if __name__ == "__main__":
    setup = "from __main__ import (binary_search, haystack, needle)"
    iterations = 10000

    for haystack_size in (10000, 100000, 1000000):
        haystack = range(haystack_size)
        for needle in (1, 6000, 9000, 1000000):
            index = binary_search(needle, haystack)
            t = timeit.timeit(
                stmt='binary_search(needle, haystack)',
                setup=setup,
                number=iterations
            )
            print "Wartość {: <8} znaleziona w tablicy haystack o wielkości {: <8} o indeksie " \
                "{: <8} w czasie równym {:.5e} s.".format(
                    needle,
                    len(haystack),
                    index,
                    t / iterations
                )
