import matplotlib.pyplot as plt

labels = ['list_bisect', 'set', 'Drzewo trie Marisa', 'Graf słów DAWG', 'Drzewo trie HAT']
ram_used = [920, 1112, 293, 958, 244]
build_time = [47, 31, 55, 63, 44]
lookup_time = [0.02, 0.003, 0.01, 0.004, 0.005]

# Tworzenie znacznie większych kół w czasie budowania
build_time = [bt * 5 for bt in build_time]

plt.figure(1)
plt.clf()
plt.scatter(ram_used, lookup_time, s=build_time)

for ram, lookup, label in zip(ram_used, lookup_time, labels):
    plt.annotate(label, (ram + 15, lookup + 0.0005))

plt.xlabel('Wielkość używanej pamięci RAM (MB – mniejsze zużycie oznacza lepszy wynik)')
plt.ylabel("Czas wyszukiwania (sekundy - krótszy czas oznacza lepszy wynik)")
plt.title(
    "Działanie kontenerów w przypadku 8,545,076 tokenów\nWielkość reprezentuje czas budowania (im mniejsza wielkość, tym lepiej)")
plt.xlim(xmin=0)
plt.tight_layout()
plt.savefig("less_ram_tries_dawg_text_8545076_tokens.png")
