import time
import numpy as np
import psutil
from matplotlib import pyplot as plt
import subprocess
import argparse
import cPickle


SHRINK = 1 


# SLEEP_FOR = 15  # sekundy
#xargs = ["python", "pi_lists_parallel.py", "1", "--processes"]

# SLEEP_FOR = 7  # sekundy
#xargs = ["python", "pi_lists_parallel.py", "2", "--processes"]

# SLEEP_FOR = 3  # sekundy
#xargs = ["python", "pi_lists_parallel.py", "4", "--processes"]

# SLEEP_FOR = 3  # sekundy
#xargs = ["python", "pi_lists_parallel.py", "8", "--processes"]

# Wersja z wątkami
# SLEEP_FOR = 20  # sekundy
#args = ["python", "pi_lists_parallel.py", "4"]
# SLEEP_FOR = 2  # sekundy
#args = ["python", "pi_lists_parallel.py", "4", "--nbr_samples_in_total=10000000"]

# Procesy robocze numpy z wątkami
# SLEEP_FOR = 0.4  # sekundy
#args = ["python", "../pi_processes_parallel/pi_numpy_parallel_worker.py", "1"]

# SLEEP_FOR = 0.4  # sekundy
#args = ["python", "../pi_processes_parallel/pi_numpy_parallel_worker.py", "8"]


# Generowanie danych
if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Opis projektu')
    parser.add_argument('--build', action="store_true",
                        default=False, help='Wymagany argument pozycyjny')
    parser.add_argument('--processes', action="store_true",
                        default=False, help='Wymagany argument pozycyjny')
    parser.add_argument(
        '--nbr_processes',
        default=1,
        type=int,
        help='Wymagany argument pozycyjny')
    args = parser.parse_args()

    xargs = ["python", "pi_lists_parallel.py"]
    xargs.append(str(args.nbr_processes))
    if args.processes:
        xargs.append("--processes")
        SLEEP_FOR = {8: 3, 4: 4, 2: 7, 1: 15}[args.nbr_processes]
    else:
        print "WERSJA Z WĄTKAMI"
        SLEEP_FOR = {4: 20}[args.nbr_processes]

    print "Użycie:", xargs

    ROOT_NAME = "08_" + "_".join(
        s.replace(
            "-",
            "").replace(
            ".",
            "_").replace(
                "=",
                "_").replace(
                    "/",
                    "_") for s in xargs[
                        1:])
    print ROOT_NAME
    PICKLE_NAME = ROOT_NAME + ".pickle"
    FIG_NAME = ROOT_NAME + ".png"

    if args.build:

        sts = subprocess.Popen(xargs)
        t = 0
        time_labels = []
        while True:
            # [27.3, 90.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0]
            percents_now = psutil.cpu_percent(percpu=True)
            percents_now.sort(reverse=True)
            if t == 0:
                percents = np.array([percents_now])  # , dtype=np.float_)
            else:
                percents = np.append(percents, [percents_now], axis=0)

            time_labels.append(str(t))

            # Przerwanie po zakończeniu procesów roboczych
            time.sleep(SLEEP_FOR)
            if sts.poll() >= 0:
                break
            t += SLEEP_FOR

        cPickle.dump((percents, time_labels), open(PICKLE_NAME, 'w'))
    else:
        # Generowanie wykresów
        (percents, time_labels) = cPickle.load(open(PICKLE_NAME, 'r'))

        f = plt.figure()

        # cmap=hot - zapewnia świetny wygląd na kolorowym ekranie
        plt.imshow(
            percents.T, interpolation='nearest', cmap='binary', origin='lower')
        plt.xlabel('Czas (sekundy)')
        plt.ylabel('Procesor (4 rdzenie i 4 hiperwątki)')
        plt.title("Wykorzystanie procesora w czasie")
        # Zapewnienie rysowania wykresu 0..100%, nawet jeśli procesor nie ma pełnego wykorzystania
        plt.clim(0, 100)
        plt.yticks(np.arange(-0.5, 8.5), np.arange(1, 9))
        plt.xticks(np.arange(-0.5, len(percents)), time_labels)

        cb = plt.colorbar(shrink=SHRINK)
        cb.set_label("Procesor %")

        plt.draw()
        plt.tight_layout()
        plt.savefig(FIG_NAME)
