"""Generator zbioru Julii bez opcjonalnego rysowania obrazów na bazie biblioteki PIL"""
import numba
from numba import jit
import time
import numpy as np

# Obszar przestrzeni zespolonej do przeanalizowania
x1, x2, y1, y2 = -1.8, 1.8, -1.8, 1.8
c_real, c_imag = -0.62772, -.42193

# Dane wyjściowe typu
#('output ma typ:', array(int32, 1d, C))
#('zs ma typ:', array(complex128, 1d, C))
# cs ma typ: array(complex128, 1d, C)
# output ma typ: array(int32, 1d, C)


@jit()  # (nopython=True)
def calculate_z_serial_purepython(maxiter, zs, cs, output):
    """Obliczanie listy output przy użyciu reguły aktualizacji zbioru Julii"""
    #output = numba.numpy_support.numpy.zeros(len(zs), dtype=np.int32)
    #print("output ma typ:", numba.typeof(output))
    #print("zs ma typ:", numba.typeof(zs))
    #print("cs ma typ:", numba.typeof(cs))
    #print("output ma typ:", numba.typeof(output))
    for i in xrange(len(zs)):
        n = 0
        z = zs[i]
        c = cs[i]
        # while n < maxiter and abs(z) < 2:
        while n < maxiter and z.real * z.real + z.imag * z.imag < 4:
            z = z * z + c
            n += 1
        output[i] = n
    # return output


#@profile
def calc_pure_python(draw_output, desired_width, max_iterations):
    """Tworzenie listy współrzędnych zespolonych (zs) i parametrów zespolonych (cs), budowanie zbioru Julii i wyświetlanie danych"""
    x_step = (float(x2 - x1) / float(desired_width))
    y_step = (float(y1 - y2) / float(desired_width))
    x = []
    y = []
    ycoord = y2
    while ycoord > y1:
        y.append(ycoord)
        ycoord += y_step
    xcoord = x1
    while xcoord < x2:
        x.append(xcoord)
        xcoord += x_step
    # Utwórz listę współrzędnych i warunek początkowy dla każdej komórki.
    # Zauważ, że warunek początkowy to stała, która z łatwością może zostać usunięta.
    # Stała służy do symulowania rzeczywistego scenariusza z kilkoma wejściami
    # przekazanymi przykładowej funkcji.
    zs = []
    cs = []
    for ycoord in y:
        for xcoord in x:
            zs.append(complex(xcoord, ycoord))
            cs.append(complex(c_real, c_imag))

    print "Długość dla x:", len(x)
    print "Łączna liczba elementów:", len(zs)
    zs2 = np.array(zs, np.complex128)
    cs2 = np.array(cs, np.complex128)
    start_time = time.time()
    output = np.zeros_like(zs2, dtype=np.int32)
    calculate_z_serial_purepython(max_iterations, zs2, cs2, output)
    end_time = time.time()
    secs = end_time - start_time
    print("Czas trwania", secs, "s")

    validation_sum = sum(output)
    print("Łączna suma elementów (do sprawdzenia poprawności):", validation_sum)


# Obliczanie zbioru Julii za pomocą czystego rozwiązania opartego na języku Python
# z wykorzystaniem wartości domyślnych rozsądnych dla laptopa.
# Ustawienie draw_output na wartość True w celu użycia biblioteki PIL do wygenerowania obrazu.
calc_pure_python(draw_output=False, desired_width=1000, max_iterations=300)
