import random
import time
import argparse


def estimate_nbr_points_in_quarter_circle(nbr_estimates):
    nbr_trials_in_quarter_unit_circle = 0
    for step in xrange(int(nbr_estimates)):
        x = random.uniform(0, 1)
        y = random.uniform(0, 1)
        is_in_unit_circle = x * x + y * y <= 1.0
        nbr_trials_in_quarter_unit_circle += is_in_unit_circle

    return nbr_trials_in_quarter_unit_circle


if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='Opis projektu')
    parser.add_argument(
        'nbr_workers', type=int, help='Liczba procesów roboczych, np. 1, 2, 4, 8')
    parser.add_argument(
        '--nbr_samples_in_total',
        type=int,
        default=1e8,
        help='Łączna liczba próbek, np. 100000000')
    parser.add_argument(
        '--processes',
        action="store_true",
        default=False,
        help='Wartość True dla procesow, wartość False dla wątków')

    args = parser.parse_args()
    if args.processes:
        print "Użycie procesów"
        from multiprocessing import Pool
    else:
        print "Użycie wątków"
        from multiprocessing.dummy import Pool

    nbr_samples_in_total = args.nbr_samples_in_total  # powinno być 1e8
    nbr_parallel_blocks = args.nbr_workers
    pool = Pool(processes=nbr_parallel_blocks)
    nbr_samples_per_worker = nbr_samples_in_total / nbr_parallel_blocks
    print "Tworzenie próbek {} dla procesu roboczego".format(nbr_samples_per_worker, nbr_parallel_blocks)
    nbr_trials_per_process = [nbr_samples_per_worker] * nbr_parallel_blocks
    t1 = time.time()
    nbr_in_quarter_unit_circles = pool.map(
        estimate_nbr_points_in_quarter_circle, nbr_trials_per_process)
    pi_estimate = sum(nbr_in_quarter_unit_circles) * \
        4 / float(nbr_samples_in_total)
    print "Przybliżona liczba pi", pi_estimate
    print "Delta:", time.time() - t1
