import os
import multiprocessing
from collections import Counter
import ctypes
import numpy as np
from prettytable import PrettyTable

# http://stackoverflow.com/questions/5549190/is-shared-readonly-data-copied-to-different-processes-for-python-multiprocessing/5550156#5550156
# Od użytkownika pv
# http://stackoverflow.com/users/108184/pv

# Uwagi Alexa Martelli wyjaśniające, dlaczego jest to utrudnione w przypadku czystego kodu Python
# http://stackoverflow.com/questions/1268252/python-possible-to-share-in-memory-data-between-2-separate-processes
# Uwaga dotycząca łączenia z poziomu podprocesu z później utworzoną pamięcią
# współużytkowaną
# http://stackoverflow.com/questions/7419159/giving-access-to-shared-memory-after-child-processes-have-already-started

# Na potrzeby raportowania można sprawdzić wartości parametrów size i vsize:
# $ ps -A -o pid,size,vsize,cmd | grep np_shared
# Użycie polecenia pmap dla procesów podrzędnych i nadrzędnego w celu uzyskania informacji o danych współużytkowanych
# $ pmap -x 25100  # Sprawdzenie współużytkowanej pamięci RAM używanej przez rozwidlone procesy podrzędne lub proces nadrzędny
# Informacje o wolnej pamięci RAM
# $ free

#SIZE_A, SIZE_B = 10000, 100
#SIZE_A, SIZE_B = 10000, 1000
# SIZE_A, SIZE_B = 10000, 40000  # 3.2 GB (3.2e9 bytes)  # DOBRE DEMO
SIZE_A, SIZE_B = 10000, 80000  # 6.2 GB - rozpoczęcie użycia obszaru wymiany za pośrednictwem narzędzia htop


def worker_fn(idx):
    """Przetwarzanie współużytkowanej tablicy np dla indeksu wiersza"""
    # Potwierdzenie, że żaden inny proces nie zmodyfikował już tej wartości
    assert main_nparray[idx, 0] == DEFAULT_VALUE
    # Wyświetlenie wewnątrz podprocesu identyfikatora PID oraz identyfikatora tablicy
    # w celu upewnienia się, że nie istnieje kopia
    if idx % 1000 == 0:
        print " {}: z indeksem {}\n  identyfikator obiektu local_nparray_in_process to {} w identyfikatorze PID {}"\
            .format(worker_fn.__name__, idx, id(main_nparray), os.getpid())
    # Tablica może zostać przetworzona w dowolny sposób; w tym miejscu dla każdego elementu w danym wierszu
    # ustawiana jest wartość identyfikatora danego procesu
    main_nparray[idx, :] = os.getpid()


if __name__ == '__main__':
    DEFAULT_VALUE = 42
    NBR_OF_PROCESSES = 4

    # Utworzenie bloku bajtów i przekształcenie w lokalną tablicę narzędzia numpy
    NBR_ITEMS_IN_ARRAY = SIZE_A * SIZE_B
    shared_array_base = multiprocessing.Array(
        ctypes.c_double, NBR_ITEMS_IN_ARRAY, lock=False)
    main_nparray = np.frombuffer(shared_array_base, dtype=ctypes.c_double)
    main_nparray = main_nparray.reshape(SIZE_A, SIZE_B)
    # Upewnienie się, że nie została utworzona żadna kopia
    assert main_nparray.base.base is shared_array_base
    print "Utworzono współużytkowaną tablicę, która zawiera {:,} nbajtów".format(main_nparray.nbytes)
    print "Identyfikator współużytkowanej tablicy to {} w identyfikatorze PID {}".format(id(main_nparray), os.getpid())
    print "Rozpoczęcie od tablicy z wartościami zerowymi:"
    print main_nparray
    print

    # Modyfikowanie danych za pomocą lokalnej tablicy narzędzia numpy
    main_nparray.fill(DEFAULT_VALUE)
    print "Oryginalna tablica wypełniona wartością {}:".format(DEFAULT_VALUE)
    print main_nparray

    raw_input("Naciśnij klawisz, aby uruchomić procesy robocze za pomocą modułu multiprocessing...")
    print

    # Tworzenie puli procesów, które będą współużytkować blok pamięci
    # globalnej tablicy numpy, a także odwołanie do bazowego bloku
    # danych, aby możliwe było utworzenie opakowania tablicy narzędzia numpy w nowych procesach
    pool = multiprocessing.Pool(processes=NBR_OF_PROCESSES)
    # Zastosowanie odwzorowania, w którym każdy indeks wiersza jest przekazywany jako parametr
    # funkcji worker_fn
    pool.map(worker_fn, xrange(SIZE_A))

    print
    print "Wartość domyślna została nadpisana przez wynik funkcji worker_fn:"
    print main_nparray
    print
    print "Weryfikacja – wyodrębnianie unikalnych wartości z elementów {:,}\nw tablicy narzędzia numpy (może to być długotrwałe)...".format(NBR_ITEMS_IN_ARRAY)
    # main_nparray.flat przeprowadza iterację dla zawartości tablicy, a ponadto nie tworzy
    # kopii
    counter = Counter(main_nparray.flat)
    print "Unikalne wartości w obiekcie main_nparray:"
    tbl = PrettyTable(["PID", "Liczba"])
    for pid, count in counter.items():
        tbl.add_row([pid, count])
    print tbl

    total_items_set_in_array = sum(counter.values())

    # Sprawdzenie, czy dla każdego elementu tablicy nie ustawiono wartości DEFAULT_VALUE
    assert DEFAULT_VALUE not in counter.keys()
    # Sprawdzenie, czy uwzględniono każdy element tablicy
    assert total_items_set_in_array == NBR_ITEMS_IN_ARRAY
    # Sprawdzenie, czy występuje liczba procesów (NBR_OF_PROCESSES) unikalnych kluczy w celu potwierdzenia, że
    # każdy proces wykonał część operacji przetwarzania
    assert len(counter) == NBR_OF_PROCESSES

    raw_input("Naciśnij klawisz, aby zakończyć...")
