def calculate_z(maxiter, zs, cs):
    """Obliczanie listy output przy użyciu reguły aktualizacji zbioru Julii"""
    output = [0] * len(zs)
    for i in range(len(zs)):
        n = 0
        z = zs[i]
        c = cs[i]
        while n < maxiter and (z.real * z.real + z.imag * z.imag) < 4:
            z = z * z + c
            n += 1
        output[i] = n
    return output


if __name__ == "__main__":
    # Tworzenie trywialnego przykładu za pomocą poprawnych typów w celu umożliwienia
    # wywołania funkcji przez inferencję typów, aby kompilator Shed Skin mógł analizować typy.
    maxiter = 1
    zs = [complex(0, 0)]
    cs = [complex(-0.62772, -.42193)]
    output = calculate_z(maxiter, zs, cs)
