#!/usr/bin/env python2.7

from __future__ import division
import time

grid_shape = (512, 512)


def evolve(grid, dt, D=1.0):
    xmax, ymax = grid_shape
    new_grid = [[0.0, ] * ymax] * xmax
    for i in xrange(xmax):
        for j in xrange(ymax):
            grid_xx = grid[(i + 1) %
                           xmax][j] + grid[(i - 1) %
                                           xmax][j] - 2.0 * grid[i][j]
            grid_yy = grid[i][(j + 1) % ymax] + \
                grid[i][(j - 1) % ymax] - 2.0 * grid[i][j]
            new_grid[i][j] = grid[i][j] + D * (grid_xx + grid_yy) * dt
    return grid


def run_experiment(num_iterations):
    # Ustawienie warunków początkowych
    xmax, ymax = grid_shape
    grid = [[0.0, ] * ymax] * xmax

    # W inicjalizacji przyjęto, że xmax <= ymax
    block_low = int(xmax * .4)
    block_high = int(xmax * .5)
    for i in xrange(block_low, block_high):
        for j in xrange(block_low, block_high):
            grid[i][j] = 0.005

    start = time.time()
    for i in range(num_iterations):
        grid = evolve(grid, 0.1)
    return time.time() - start

if __name__ == "__main__":
    run_experiment(500)
