import bisect
import random


def find_closest(haystack, needle):
    # Funkcja bisect.bisect_left zwróci pierwszą wartość w tablicy haystack,
    # która jest większa od wartości needle
    i = bisect.bisect_left(haystack, needle)
    if i == len(haystack):
        return i - 1
    elif haystack[i] == needle:
        return i
    elif i > 0:
        j = i - 1
        # Ponieważ wiadomo, że wartość jest większa niż wartość needle (i odwrotnie w przypadku
        # wartości w j), nie jest konieczne użycie w tym miejscu wartości bezwzględnych
        if haystack[i] - needle > needle - haystack[j]:
            return j
    return i


if __name__ == "__main__":
    important_numbers = []
    for i in range(10):
        new_number = random.randint(0, 1000)
        bisect.insort(important_numbers, new_number)

    # Lista important_numbers będzie już uporządkowana, ponieważ wstawiono nowe elementy
    # za pomocą funkcji bisect.insort
    print(important_numbers)
    # > [14, 265, 496, 661, 683, 734, 881, 892, 973, 992]

    closest_index = find_closest(important_numbers, -250)
    print(f"Najbliższa wartość dla -250: {important_numbers[closest_index]}")
    # > Najbliższa wartość dla -250: 14

    closest_index = find_closest(important_numbers, 500)
    print(f"Najbliższa wartość dla 500: {important_numbers[closest_index]}")
    # > Najbliższa wartość dla 500: 496

    closest_index = find_closest(important_numbers, 1100)
    print(f"Najbliższa wartość dla 1100: {important_numbers[closest_index]}")
    # > Najbliższa wartość dla 1100: 992
