#!/usr/bin/env python
# -*- coding: 852 -*-

import os
from xml.dom import minidom

def test_html_report(testpath):
    print """
    ================================
    TWORZENIE RAPORTU HTML
    ================================
    """
    prompt = """
    Wprowad dat wywoania testu
    w formacie '01-01-2008'
    """
    test_date = raw_input (prompt)
    
    test_run_file = testpath + test_date + ".xml"
    
    #Get nodes from XML document
    try:
        test_run = minidom.parse(test_run_file)
    except:
        print "\n\tBd otwarcia wynikw wywoania!\n"
        raw_input("Nacinij [Enter]:  ")
        return
    test_result_node = test_run.childNodes[0]
    test_firstname_node = test_result_node.childNodes[1]
    test_lastname_node = test_result_node.childNodes[3]
    test_prime_node = test_result_node.childNodes[5]
    test_passed_node = test_result_node.childNodes[7]
    test_failed_node = test_result_node.childNodes[9]
    test_error_node = test_result_node.childNodes[11]
    
    #Get text from relevant nodes
    test_firstname_result = test_firstname_node.firstChild.data
    test_lastname_result = test_lastname_node.firstChild.data
    test_prime_result = test_prime_node.firstChild.data
    test_passed_result = test_passed_node.firstChild.data
    test_failed_result = test_failed_node.firstChild.data
    test_error_result = test_error_node.firstChild.data
    
    #Produce result to html
    html_output = u"""
    <HTML>
    <TITLE>Raport z testw - %s</TITLE>
    <HR>
    <H1>WYNIKI WYWOANIA TESTW %s</H1>
    <HR>
    <BODY>
    Test imienia - %s<br>
    Test nazwiska - %s<br>
    Test liczby pierwszej - %s<br>
    <HR>
    Liczba testw zakoczonych powodzeniem:  %s<br>
    Liczba testw zakoczonych niepowodzeniem:  %s<br>
    Liczba testw zakoczoncyh bdem:  %s<br>
    </BODY>
    </HTML>
    """ % (test_date, test_date, test_firstname_result, test_lastname_result, \
    test_prime_result, test_passed_result, test_failed_result, test_error_result)
    
    filename = os.path.join(os.curdir, 'test_report_html', test_date + ".html")
    output_file = open(filename, 'w')
    output_file.write(html_output.encode('utf8'))
    output_file.close()
    
    print "\n\t-- Zakoczono generowanie raportu HTML --"
    raw_input("\tNacinij [Enter]:  ")
    

    
