# -*- coding: utf-8 -*-

"""
Moduł przykładowy.

Zawiera jedną funkcję factorial(), przykładowe wywołanie:

>>> factorial(5)
120
"""

def factorial(n):
    """Funkcja silni. Zwraca wartość n! dla liczby całkowitej n >= 0.

    Jeśli wynik miesći się w wartości typu int,, zwraca int.
    W przeciwnym wypadku zwraca wartości typu long.

    >>> [factorial(n) for n in range(6)]
    [1, 1, 2, 6, 24, 120]
    >>> [factorial(long(n)) for n in range(6)]
    [1, 1, 2, 6, 24, 120]
    >>> factorial(30)
    265252859812191058636308480000000L
    >>> factorial(30L)
    265252859812191058636308480000000L
    >>> factorial(-1)
    Traceback (most recent call last):
        ...
    ValueError: n must be >= 0

    Argumenty typu zmiennoprzecinkowego są dopuszczalne,
    ale wartość musi być równoważna liczbie całkowitej, na przykład:
    >>> factorial(30.1)
    Traceback (most recent call last):
        ...
    ValueError: n must be exact integer
    >>> factorial(30.0)
    265252859812191058636308480000000L

    Argumenty nie mogą być bardzo duże:
    >>> factorial(1e100)
    Traceback (most recent call last):
        ...
    OverflowError: n too large
    """

    import math
    if not n >= 0:
        raise ValueError("n musi być >= 0")
    if math.floor(n) != n:
        raise ValueError("n musi być liczbą całkowitą")
    if n+1 == n:  # catch a value like 1e300
        raise OverflowError("n too large")
    result = 1
    factor = 2
    while factor <= n:
        result *= factor
        factor += 1
    return result

def _test():
    import doctest
    doctest.testmod()

if __name__ == "__main__":
    _test()

