# -*- coding: 852 -*-
import os, pickle, difflib, sys, pprint

def createSnapshot(directory, filename):    
    cumulative_directories = []
    cumulative_files = []

    for root, dirs, files in os.walk(directory):
        cumulative_directories = cumulative_directories + dirs
        cumulative_files = cumulative_files + files
        
    try:
        output = open(filename, 'wb')
        pickle.dump(cumulative_directories, output, -1)
        pickle.dump(cumulative_files, output, -1)
        output.close()
    except:
        print "Wystpiy problemy przy zapisie pliku migawki!"
    
    raw_input("Nacinij [Enter]...")
    return

def listSnapshots(extension):
    snaplist = []
    filelist = os.listdir(os.curdir)
    for item in filelist:
        if item.endswith(extension):
            snaplist.append(item)
    print '''
    Lista migawek:
    ========================
    '''
    printList(snaplist)
    
    raw_input("Nacinij [Enter]...")
    
            

def compareSnapshots(snapfile1, snapfile2):

    try:
        pkl_file = open(snapfile1, 'rb')
        dirs1 = pickle.load(pkl_file)
        files1 = pickle.load(pkl_file)
        pkl_file.close()

        pk2_file = open(snapfile2, 'rb')
        dirs2 = pickle.load(pk2_file)
        files2 = pickle.load(pk2_file)
        pk2_file.close()
    except:
        print "Wystpiy problemy przy odczycie plikw migawek!"
        raw_input("\n\nNacinij [Enter]...")
        return

    result_dirs = list(difflib.unified_diff(dirs1, dirs2))
    result_files = list(difflib.unified_diff(files1, files2))

    added_dirs = []
    removed_dirs = []
    added_files = []
    removed_files = []
    
    for result in result_files:
        if not result.endswith("\n"):
            if result.startswith('+'):
                resultadd = result.strip('+')
                added_files.append(resultadd)
            elif result.startswith('-'):
                resultsubtract = result.strip('-')
                removed_files.append(resultsubtract)

    for result in result_dirs:
        if not result.endswith("\n"):
            if result.startswith('+'):
                resultadd = result.strip('+')
                added_dirs.append(resultadd)
            elif result.startswith('-'):
                resultsubtract = result.strip('-')
                removed_dirs.append(resultsubtract)
                
    print "\n\nDodane katalogi:\n"
    printList(added_dirs)
    print "\n\nDodane pliki:\n"
    printList(added_files)
    print "\n\nUsunite katalogi:\n"
    printList(removed_dirs)
    print "\n\nUsunite pliki:\n"
    printList(removed_files)
    raw_input("\n\nNacinij [Enter]...")

def showHelp():
    os.system('cls')
    print '''
    NARZDZIE DO WYKONYWANIA MIGAWEK KATALOGW I PLIKW
    ====================================
    Ten program suy do tworzenia migawek drzew plikw i katalogw,
    wywietlania listy utworzonych migawek zapisanych w biecym katalogu i
    porwnywania dwch migawek w celu zapoznania si z plikami i katalogami
    dodanymi lub usunitymi w okresie midzy wykonaniem pierwszej i drugiej
    migawki.
    
    Z menu programu mona wywoa nastpujce operacje:
    1.  Utwrz migawk
    2.  Wypisz pliki migawki
    3.  Porwnaj migawki
    4.  Pomoc (niniejszy ekran)
    5.  Koniec

    
    '''
    raw_input("Nacinij [Enter]...")

def invalidChoice():
    sys.stderr.write("NIEPRAWIDOWA OPCJA, SPRBUJ PONOWNIE!")
    raw_input("\n\nNacinij [Enter]...")
    return
    
    
def printList(list):
    fulllist = ""
    indexnum = 1
    
    if len(list) > 20:
        for item in list:
            print "\t\t" + item,
            if (indexnum)%3 == 0:
                print "\n"
            indexnum = indexnum + 1
    else:
        for item in list:
            print "\t" + item
