# -*- coding: 852 -*-

"""
Modu przykadowy.

Zawiera jedn funkcj factorial(), przykadowe wywoanie:

>>> factorial(5)
120
"""

def factorial(n):
    """Funkcja silni. Zwraca warto n! dla liczby cakowitej n >= 0.

    Jeli wynik miesi si w wartoci typu int,, zwraca int.
    W przeciwnym wypadku zwraca wartoci typu long.

    >>> [factorial(n) for n in range(6)]
    [1, 1, 2, 6, 24, 120]
    >>> [factorial(long(n)) for n in range(6)]
    [1, 1, 2, 6, 24, 120]
    >>> factorial(30)
    265252859812191058636308480000000L
    >>> factorial(30L)
    265252859812191058636308480000000L
    >>> factorial(-1)
    Traceback (most recent call last):
        ...
    ValueError: n must be >= 0

    Argumenty typu zmiennoprzecinkowego s dopuszczalne,
    ale warto musi by rwnowana liczbie cakowitej, na przykad:
    >>> factorial(30.1)
    Traceback (most recent call last):
        ...
    ValueError: n must be exact integer
    >>> factorial(30.0)
    265252859812191058636308480000000L

    Argumenty nie mog by bardzo due:
    >>> factorial(1e100)
    Traceback (most recent call last):
        ...
    OverflowError: n too large
    """

    import math
    if not n >= 0:
        raise ValueError("n musi by >= 0")
    if math.floor(n) != n:
        raise ValueError("n musi by liczb cakowit")
    if n+1 == n:  # catch a value like 1e300
        raise OverflowError("n too large")
    result = 1
    factor = 2
    while factor <= n:
        result *= factor
        factor += 1
    return result

def _test():
    import doctest
    doctest.testmod()

if __name__ == "__main__":
    _test()

