﻿
# Rozdział 11. Przetwarzanie języka naturalnego (NLP)
## 11.2. Klasa „TextBlob”
### 11.2.1. Instalowanie modułu „textblob”
#conda install -c conda-forge textblob
# --------------------------------
#ipython -m textblob.download_corpora

### 11.2.3. Tworzenie obiektów klasy „TextBlob”
from textblob import TextBlob
tekst = 'Today is a beautiful day. Tomorrow looks like bad weather.'
blob = TextBlob(tekst)
blob

### 11.2.4. Podział na zdania i słowa
blob.sentences
blob.words

### 11.2.5. Rozpoznawanie części mowy
blob
blob.tags

### 11.2.6. Wyodrębnianie fraz rzeczownikowych
blob
blob.noun_phrases

#### 11.2.7.1. Klasa „Sentiment”
blob
blob.sentiment

#### 11.2.7.2. Polaryzacja i subiektywizm w klasie „Sentiment”
%precision 3
blob.sentiment.polarity
blob.sentiment.subjectivity

#### 11.2.7.3. Określanie sentymentu zdania
for zdanie in blob.sentences:
    print(zdanie.sentiment)

#### 11.2.8. Bayesowska analiza sentymentu
from textblob.sentiments import NaiveBayesAnalyzer
tekst = 'Today is a beautiful day. Tomorrow looks like bad weather.' 
blob = TextBlob(tekst, analyzer=NaiveBayesAnalyzer())
blob
blob.sentiment

for zdanie in blob.sentences:
    print(zdanie.sentiment)

### 11.2.9. Wykrywanie języka i tłumaczenie między językami
blob
blob.detect_language()
polish = blob.translate(to='pl')

polish
polish.detect_language()
chinese = blob.translate(to='zh')
chinese
chinese.detect_language()

polish.translate()
chinese.translate()

### 11.2.10. Pluralizacja i singularyzacja
from textblob import Word
index = Word('index')
index.pluralize()
cacti = Word('cacti')
cacti.singularize()
# --------------------------------
from textblob import TextBlob
animals = TextBlob('dog cat fish bird').words
animals.pluralize()

### 11.2.11. Weryfikacja i korekcja pisowni
from textblob import Word
wyraz = Word('theyr')
wyraz.spellcheck()

wyraz = Word('theyr')
wyraz.correct()  # poprawny wyraz o największym prawdopodobieństwie
# --------------------------------
from textblob import TextBlob 
zdanie = TextBlob('Ths sentense has missplled wrds.')
zdanie.correct()

### 11.2.12. Normalizowanie słów — stematyzacja i lemmatyzacja
from textblob import Word
wyraz = Word('varieties')
wyraz.stem()
wyraz.lemmatize()

### 11.2.13. Częstotliwość występowania słów
from pathlib import Path
from textblob import TextBlob
blob = TextBlob(Path('../../RomeoAndJuliet.txt').read_text())
blob.word_counts['juliet']
blob.word_counts['romeo']
blob.word_counts['thou']
blob.words.count('joy')
blob.noun_phrases.count('lady capulet')

#### 11.2.14.1. Pobieranie definicji
from textblob import Word
happy = Word('happy')
happy.definitions

#### 11.2.14.2. Poszukiwanie synonimów
happy.synsets
synonimy = set()

for synset in happy.synsets:
    for lemma in synset.lemmas():
        synonimy.add(lemma.name())

synonimy

#### 11.2.14.3. Poszukiwanie antonimów
lemmas = happy.synsets[0].lemmas()
lemmas
lemmas[0].antonyms()

### 11.2.15. Usuwanie słów nieznaczących — stoplisty
import nltk
nltk.download('stopwords')
from nltk.corpus import stopwords
stops = stopwords.words('english')
# --------------------------------
from textblob import TextBlob
blob = TextBlob('Today is a beautiful day.')
[wyraz for wyraz in blob.words if wyraz not in stops]

### 11.2.16. Wyszukiwanie n-gramów
from textblob import TextBlob
tekst = 'Today is a beautiful day. Tomorrow looks like bad weather.'
blob = TextBlob(tekst)
blob.ngrams()
blob.ngrams(5)
