# karta.py
#-*- coding: 1250 -*-

# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
# Revised by A.Grayski, (C) Copyright 2020 by Helion Publishing


"""Klasa reprezentujca kart do gry: 
   jej warto, kolor i nazwe pliku z obrazkiem"""

class Karta:
    FACES = ['As', '2', '3', '4', '5', '6',
             '7', '8', '9', '10', 'Walet', 'Dama', 'Krl']
    SUITS = ['Kier', 'Karo', 'Trefl', 'Pik']
    
    FACE_IMAGE_MARKS = ['Ace', '2', '3', '4', '5', '6',
             '7', '8', '9', '10', 'Jack', 'Queen', 'King']
             
    SUIT_IMAGE_MARKS = ['Hearts', 'Diamonds', 'Clubs', 'Spades']         

    def __init__(self, face, suit):
        """Inicjowanie karty - warto i kolor."""
        self._face = face
        self._suit = suit
        
        self._face_image_mark = '?'
        
        if face in Karta.FACES:
            ndx = Karta.FACES.index(face)
            self._face_image_mark = Karta.FACE_IMAGE_MARKS[ndx]
        else:
            raise ValueError('Nieprawidowa warto karty')    
        
        self._suit_image_mark = '?'
        
        if suit in Karta.SUITS:
            ndx = Karta.SUITS.index(suit)
            self._suit_image_mark = Karta.SUIT_IMAGE_MARKS[ndx]
        else:
            raise ValueError('Nieprawidowy kolor karty')    
        

    @property
    def face(self):
        """Zwraca warto karty."""
        return self._face

    @property
    def suit(self):
        """Zwraca kolor karty."""
        return self._suit

    @property
    def nazwa_pliku_obrazu(self):
        """Zwraca nazw pliku z obrazem karty."""
        return self._face_image_mark + '_of_' + self._suit_image_mark + '.png'

    def __repr__(self):
        """Zwraca oficjaln reprezentacj tekstow karty."""
        return f"Card(face='{self.face}', suit='{self.suit}')"     

    def __str__(self):
        """Zwraca przyjazn reprezentacj tekstow karty."""
        return f'{self.face} {self.suit}'

    def __format__(self, format):
        """Zwraca sformatowan reprezentacj tekstow karty"""
        return f'{str(self):{format}}'



##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
