﻿## 5.18. Wprowadzenie do Data Science: symulacje i ich statyczna wizualizacja
### 5.18.1. Uruchamianie interpretera IPython ze wsparciem dla biblioteki Matplotlib
%matplotlib

### 5.18.2. Importowanie bibliotek
import matplotlib.pyplot as plt
import numpy as np
import random
import seaborn as sns

### 5.18.3. Symulowanie serii rzutów i obliczanie częstotliwości wyników
seria=600
rzuty = [random.randrange(1, 7) for i in range(seria)]
oczka, ile_razy = np.unique(rzuty, return_counts=True)

### 5.18.4. Tworzenie zaczątków wykresu
seria_str = f'{seria:,}'.replace(',', '. ')
nazwa_wykresu = f'Częstotliwości wystąpień liczb oczek po wykonaniu {seria_str} rzutów'
sns.set_style('whitegrid')
osie = sns.barplot(x=oczka, y=ile_razy, palette='bright')

### 5.18.5. Zdefiniowanie tytułu i etykiet przy osiach
osie.set_title(nazwa_wykresu)
osie.set(xlabel='Liczba oczek', ylabel='Częstotliwość')

### 5.18.6. Finalizowanie wykresu
osie.set_ylim(top=max(ile_razy) * 1.10)

for pasek, ile_razy_liczba_oczek in zip(osie.patches, ile_razy):
    tekst_x = pasek.get_x() + pasek.get_width() / 2.0
    tekst_y = pasek.get_height()
    ile_razy_liczba_oczek_str = f'{ile_razy_liczba_oczek:,}'.replace(',', '. ')
    tekst = f'{ile_razy_liczba_oczek_str}\n{ile_razy_liczba_oczek / seria:.3%}'.replace('.', ',')
    osie.text(tekst_x, tekst_y, tekst,
              fontsize=11, ha='center', va='bottom')

### 5.18.7. Ponawianie symulacji — elementy magii IPythona
plt.cla()

### 5.18.9. Uruchomienie symulacji ze skryptu — parametry wiersza poleceń 
run RollDie.py 600
