#-*- coding: 1250 -*-
## 16.4. Analiza przypadku: dokumenty JSON w bazie MongoDB
# https://www.mongodb.com/download-center/community

### 16.4.1. Instalowanie bibliotek Pythona dla interakcji z MongoDB
# conda install -c conda-forge pymongo
# conda install -c conda-forge dnspython

### 16.4.3. Tworzenie klastera MongoDB Atlas
# https://mongodb.com/

#### 16.4.4.1. Uwierzytelnianie w Twitterze za pomoc biblioteki Tweepy
import tweepy, keys

auth = tweepy.OAuthHandler(
   keys.consumer_key, keys.consumer_secret)
auth.set_access_token(keys.access_token,
   keys.access_token_secret)

api = tweepy.API(auth, wait_on_rate_limit=True,
                 wait_on_rate_limit_notify=True)
                 
#### 16.4.4.2. Zaadowanie danych o senatorach
import pandas as pd
senators_df = pd.read_csv('senators.csv')
senators_df['ID_Twittera'] = senators_df['ID_Twittera'].astype(str)
pd.options.display.max_columns = 6
senators_df.head()

#### 16.4.4.3. Konfigurowanie klienta MongoClient
from pymongo import MongoClient
atlas_client = MongoClient(keys.mongo_connection_string)
db = atlas_client.senators

#### 16.4.4.4. Konfigurowanie strumienia tweetw
from tweetlistener import TweetListener
tweet_limit = 10000
tweet_limit = 100

twitter_stream = tweepy.Stream(api.auth,
          TweetListener(api, db, tweet_limit))

#### 16.4.4.5. Uruchomienie strumienia tweetw
twitter_stream.filter(track=senators_df.Konto_Twittera.tolist(),
    follow=senators_df.ID_Twittera.tolist())

#### 16.4.4.7. Zliczanie tweetw dla kadego senatora
db.tweets.create_index([('$**', 'text')])
tweet_counts = []
for senator in senators_df.Konto_Twittera:
    tweet_counts.append(db.tweets.count_documents(
           {"$text": {"$search": senator}}))

#### 16.4.4.8. Statystyka tweetw dla kadego senatora
tweet_counts_df = senators_df.assign(Tweety=tweet_counts)
tweet_counts_df.sort_values(by='Tweety',
                    ascending=False).head(10)

#### 16.4.4.9. Geokodowanie stanw USA
from geopy import OpenMapQuest
import time
from state_codes import state_codes
geo = OpenMapQuest(api_key=keys.mapquest_key)
states = tweet_counts_df.Stan.unique()
states.sort()

locations = []
for state in states:
    processed = False
    delay = .1

    while not processed:
        try:
            state_name = state_codes[state]
            locations.append(
                geo.geocode(state_name + ', USA'))
            print(state_name, locations[-1])
            processed = True
        except: # przeterminowanie, odczekaj chwil i sprbuj ponownie
            print('OpenMapQuest:', state_name,
                '- upyn limit czasu oczekiwania.')
            time.sleep(delay)
            delay += .3

#### 16.4.4.10. Grupowanie tweetw dla poszczeglnych stanw
tweets_counts_by_state = tweet_counts_df.groupby(
                      'Stan', as_index=False).sum()

tweets_counts_by_state.head()

#### 16.4.4.11. Tworzenie mapy
import folium
usmap = folium.Map(location=[39.8283, -98.5795],
                   zoom_start=4, detect_retina=True,
                   tiles='Stamen Toner')
                       
#### 16.4.4.12. Kolorowanie mapy w technologii Choropleth
# https://raw.githubusercontent.com/python-visualization/folium/master/examples/data/us-states.json
# http://geojson.org/ .
# --------------------------------
choropleth = folium.Choropleth(
    geo_data='us-states.json',
    name='choropleth',
    data=tweets_counts_by_state,
    columns=['Stan', 'Tweety'],
    key_on='feature.id',
    fill_color='YlOrRd',
    fill_opacity=0.7,
    line_opacity=0.2,
    legend_name='Tweety wg stanw'
   ).add_to(usmap)    


layer = folium.LayerControl().add_to(usmap)
# --------------------------------
# http://python-visualization.github.io/folium/modules.html#folium.features.Choropleth

#### 16.4.4.13. Tworzenie markerw dla poszczeglnych stanw
sorted_df = tweet_counts_df.sort_values(
               by='Tweety', ascending=False)

sorted_df.groupby('Stan')

for index, (name, group) in enumerate(sorted_df.groupby('Stan')):
    strings = [state_codes[name]] # kompozycja tekstu do wywietlenia

    for s in group.itertuples():
        strings.append(
            f'{s.Nazwisko} ({s.Partia}); Tweetw: {s.Tweety}')

    text = '<br>'.join(strings)
    marker = folium.Marker(
        (locations[index].latitude, locations[index].longitude),
        popup=text)
    marker.add_to(usmap)

#### 16.4.4.14. Wywietlanie mapy
usmap.save('SenatorsTweets.html')

print('Otwieranie przegldarki:')
print()
import webbrowser
webbrowser.open('SenatorsTweets.html') 
