#-*- coding: 1250 -*-
## 11.3. Wizualizacja statystyki sw
### 11.3.1. Supkowy wykres czstotliwoci z biblioteki Pandas

#### 11.3.1.1. Zaadowanie danych
from pathlib import Path
from textblob import TextBlob
blob = TextBlob(Path('../../RomeoAndJuliet.txt').read_text())

from nltk.corpus import stopwords
stop_words = stopwords.words('english')

#### 11.3.1.2. Zliczanie czstotliwoci
items = blob.word_counts.items()

#### 11.3.1.3. Eliminowanie sw nieznaczcych
items = [item for item in items if item[0] not in stop_words]

#### 11.3.1.4. Sortowanie wedug czstotliwoci
from operator import itemgetter
sorted_items = sorted(items, key=itemgetter(1), reverse=True)

#### 11.3.1.5. Czowka rankingu
top20 = sorted_items[0:21]

#### 11.3.1.6. Czowka w ramce danych
import pandas as pd
df = pd.DataFrame(top20, columns=['sowo', 'wystpienia'])
df

#### 11.3.1.7. Wykres z ramki danych
osie = df.plot.bar(x='sowo', y='wystpienia', legend=False)
import matplotlib.pyplot as plt
matplotlib
plt.gcf().tight_layout()

#### 11.3.2.1. Instalowanie moduu wordcloud 
# conda install -c conda-forge wordcloud

#### 11.3.2.2. Wczytanie tekstu
from pathlib import Path
tekst = Path('../../RomeoAndJuliet.txt').read_text()

#### 11.3.2.3. Ksztatowanie chmury za pomoc maski
import imageio
mask_image = imageio.imread('mask_heart.png')

#### 11.3.2.4. Konfigurowanie obiektu WordCloud 
from wordcloud import WordCloud
wordcloud = WordCloud(colormap='prism', mask=mask_image,
                      background_color='white')
#### 11.3.2.5. Generowanie chmury
wordcloud = wordcloud.generate(tekst)

#### 11.3.2.6. Zapis chmury w pliku graficznym
wordcloud = wordcloud.to_file('RomeoAndJulietHeart.png')

#### 11.3.2.8. Wywietlanie chmury za pomoc biblioteki Matplotlib
matplotlib
import matplotlib.pyplot as plt
plt.imshow(wordcloud)
