## 10.16. Wprowadzenie do Data Science: szeregi czasowe i prosta regresja liniowa
#### 10.16.2.1. Liniowy zwizek midzy wielkociami
c = lambda f: 5 / 9 * (f - 32)
temperatury = [(f, c(f)) for f in range(0, 101, 10)]
import pandas as pd
temperatury_df = pd.DataFrame(temperatury, columns=['Fahrenheit', 'Celsjusz'])
osie = temperatury_df.plot(x='Fahrenheit', y='Celsjusz', style='.-')
y_label = osie.set_ylabel('Stopnie Celsjusza')
x_label = osie.set_xlabel('Stopnie Fahrenheita')

### 10.16.7. adowanie szeregu czasowego do ramki danych
nyc = pd.read_csv('ave_hi_nyc_jan_1895-2018.csv')
nyc.head()
nyc.tail()

### 10.16.8. Preparacja danych
nyc.columns = ['Data', 'Temperatura', 'Odchylenie']
nyc.head()
nyc.Data.dtype

nyc.Data = nyc.Data.floordiv(100)
nyc.head()

### 10.16.9. Statystyka opisowa szeregu czasowego

pd.set_option('precision', 2)

nyc.Temperatura.describe()

### 10.16.10. Prognozowanie pogody na podstawie regresji liniowej
from scipy import stats
linear_regression = stats.linregress(x=nyc.Data,
                                     y=nyc.Temperatura)

linear_regression.slope     # nachylenie
linear_regression.intercept # przesunicie

linear_regression.slope * 2021 + linear_regression.intercept

linear_regression.slope * 1890 + linear_regression.intercept

### 10.16.11. Wizualizacja regresji liniowej w szeregu czasowym
%matplotlib
import seaborn as sns
sns.set_style('whitegrid')
osie = sns.regplot(x=nyc.Data, y=nyc.Temperatura)
 
osie.set_ylim(10, 70)
