## 8.12. Podstawy wyrae regularnych
### 8.12.3. Modu re i funkcja fullmatch
import re

#### 8.12.3.1. Dopasowywanie literaw
wzorzec = '02215'
'Pasuje' if re.fullmatch(wzorzec, '02215') else 'Nie pasuje'
'Pasuje' if re.fullmatch(wzorzec, '51220') else 'Nie pasuje'

#### 8.12.3.2. Metaznaki, klasy znakw i kwantyfikatory
'Poprawny' if re.fullmatch(r'\d{5}', '02215') else 'Niepoprawny'
'Poprawny' if re.fullmatch(r'\d{5}', '9876') else 'Niepoprawny'

#### 8.12.3.2.2. Definiowanie klas znakw
wzorzec = '[A-Zƌ][a-z󜟿]*'
'Poprawne' if re.fullmatch(wzorzec, 'Grayski') else 'Niepoprawne'
'Poprawne' if re.fullmatch(wzorzec, 'grayski') else 'Niepoprawne'
'Pasuje' if re.fullmatch('[^a-z]', 'A') else 'Nie pasuje'
'Pasuje' if re.fullmatch('[^a-z]', 'a') else 'Nie pasuje'
'Pasuje' if re.fullmatch('[*+$]', '*') else 'Nie pasuje'
'Pasuje' if re.fullmatch('[*+$]', '!') else 'Nie pasuje'

#### 8.12.3.3. Kwantyfikatory * i +
wzorzec = '[A-Zƌ][a-z󜟿]+'
'Poprawne' if re.fullmatch(wzorzec, 'As') else 'Niepoprawne'
'Poprawne' if re.fullmatch(wzorzec, 'X') else 'Niepoprawne'
wzorzec = '[A-Zƌ][a-z󜟿]*ski'
'Poprawne' if re.fullmatch(wzorzec, 'Grayski') else 'Niepoprawne'

#### 8.12.3.4. Inne kwantyfikatory
'Poprawnie' if re.fullmatch('labell?ed', 'labelled') else 'Niepoprawnie'
'Poprawnie' if re.fullmatch('labell?ed', 'labeled') else 'Niepoprawnie'
'Poprawnie' if re.fullmatch('labell?ed', 'labellled') else 'Niepoprawnie'
'Pasuje' if re.fullmatch(r'\d{3,}', '123') else 'Nie pasuje'
'Pasuje' if re.fullmatch(r'\d{3,}', '1234567890') else 'Nie pasuje'
'Pasuje' if re.fullmatch(r'\d{3,}', '12') else 'Nie pasuje'
'Pasuje' if re.fullmatch(r'\d{3,6}', '123') else 'Nie pasuje'

'Pasuje' if re.fullmatch(r'\d{3,6}', '123456') else 'Nie pasuje'
'Pasuje' if re.fullmatch(r'\d{3,6}', '1234567') else 'Nie pasuje'
'Pasuje' if re.fullmatch(r'\d{3,6}', '12') else 'Nie pasuje'

#### 8.12.4.1. Funkcja sub  zastpowanie dopasowa
import re
re.sub(r'\t', ', ', '1\t2\t3\t4')
re.sub(r'\t', ', ', '1\t2\t3\t4', count=2)

#### 8.12.4.2. Funkcja split  podzia acucha wedug wzorca
re.split(r',\s*', '1, 2, 3,4, 5,6,7,8')
re.split(r',\s*', '1, 2, 3,4, 5,6,7,8', maxsplit=3)

#### 8.12.5.1. Funkcja search  poszukiwanie pierwszego dopasowania
import re
source = 'Python dla programistw'
result = re.search('Python', source)
if result:
    print(result.start(), result.end(), result.group())
    print(source[result.start():result.end()])
else:
    print('Brak dopasowania')

source = 'Python dla programistw'
result = re.search('python', source)
if result:
    print(result.start(), result.end(), result.group())
    print(source[result.start():result.end()])
else:
    print('Brak dopasowania')

result = re.search('dla', source)
result.group() if result else 'Brak dopasowania'

result = re.match('dla', source)
result.group() if result else 'Brak dopasowania'

#### 8.12.5.2. Dopasowywanie z ignorowaniem rnic w wielkociach liter
result = re.search('DLA', source, flags=re.IGNORECASE)
result.group() if result else 'Brak dopasowania'

#### 8.12.5.3. Metaznaki wymagajce zakotwiczenia dopasowania na pocztku lub kocu acucha rdowego
source = 'Programowanie w jzyku Python\nDla programistw'

result = re.search('^Program', source)
result.group() if result else 'Brak dopasowania'

result = re.search('^Dla', source)
result.group() if result else 'Brak dopasowania'

result = re.search('^Dla', source, flags=re.MULTILINE)
result.group() if result else 'Brak dopasowania'

result = re.search('stw$', source)
result.group() if result else 'Brak dopasowania'

result = re.search('Python$', source)
result.group() if result else 'Brak dopasowania'

result = re.search('Python$', source, flags=re.MULTILINE)
result.group() if result else 'Brak dopasowania'

#### 8.12.5.4. Funkcje findall i finditer  znajdowanie wszystkich dopasowa
kontakt = 'Wydawnictwo Helion tel. 32-230-98-63, faks 32-333-92-56'
re.findall('\d{2}-\d{3}-\d{2}-\d{2}', kontakt)

for telefon in re.finditer('\d{2}-\d{3}-\d{2}-\d{2}', kontakt):
    print(telefon.start(), telefon.end(), '   ', telefon.group())

#### 8.12.5.5. Wyodrbnianie poszczeglnych dopasowa
wzorzec = r'([A-Zʣӌ][a-z󜟿]+ [A-Zʣӌ][a-z󜟿]+), e-mail: (\w+@\w+\.\w{2,3})'
tekst = 'wity Mikoaj, e-mail: santaclaus@helion.pl'
result = re.search(wzorzec, tekst)
if result:
    print(result.group())
    print(result.groups())
    print()
     
    for i in range(0, len(result.groups())):
        print(i, '  ', result.groups()[i])  
        
    print()    

    for i in range(0, len(result.groups())):
        print(i+1, '  ', result.group(i+1)) 

else:
    print('Brak dopasowania')        
