## 7.15. Wprowadzenie do Data Science: szeregi i ramki danych biblioteki Pandas
#### 7.15.1.1. Tworzenie szeregu z domylnymi indeksami
import pandas as pd
oceny = pd.Series([87, 100, 94])

#### 7.15.1.2. Wypisywanie szeregw
oceny

#### 7.15.1.3. Inicjowanie szeregu zadan wartoci
pd.Series(98.6, range(3))     # range()
pd.Series(98.6, [1, 2, 3, 5]) # lista
pd.Series(98.6, (1, 2, 3, 5)) # krotka
pd.Series(98.6, {1, 2, 3, 5}) # zbir

#### 7.15.1.4. Dostp do elementw szeregu
oceny[0]
type(oceny[0])
x = pd.Series(98.6, [1, 2, 3, 3, 5, 2, 1, 1])
x[1]
type(x[1])

#### 7.15.1.5. Parametry statystyki opisowej dla szeregu
oceny.count()
oceny.mean()
oceny.min()
oceny.max()
oceny.var()
oceny.std()
oceny.describe()

#### 7.15.1.6. Tworzenie szeregu ze specyficznymi indeksami
oceny = pd.Series([87, 100, 94], index=['Waldemar', 'Ewa', 'Stefan'])
oceny

#### 7.15.1.7. Tworzenie szeregu na podstawie sownika
oceny = pd.Series({'Waldemar': 87, 'Ewa': 100, 'Stefan': 94})
oceny

#### 7.15.1.8. Dostp do elementw szeregu za pomoc specyficznych indeksw
oceny['Ewa']
oceny.Waldemar
oceny.dtype
oceny.values
oceny.index

#### 7.15.1.9. acuchy znakw jako elementy szeregu 
warsztat = pd.Series(['Motek', 'Pia', 'Imado'])
warsztat
warsztat.str.contains('')
warsztat.str.contains('a')
warsztat.str.upper()

#### 7.15.2.1. Tworzenie ramki danych na podstawie sownika
import pandas as pd
dziennik_ocen = {'Waldemar': [87, 96, 70], 'Ewa': [100, 87, 90],
                 'Stefan': [94, 77, 90], 'Katarzyna': [100, 81, 82],
                 'Bogdan': [83, 65, 85]}

oceny = pd.DataFrame(dziennik_ocen)
oceny

#### 7.15.2.2. Specyficzne indeksowanie ramki danych  atrybut index 
oceny.index = ['Algebra', 'Programowanie', 'Statystyka']
oceny
oceny['Ewa']
oceny.Stefan

#### 7.15.2.4. Selekcja wierszy za pomoc atrybutw loc i iloc
oceny.loc['Algebra']
oceny.iloc[1]

#### 7.15.2.5. Selekcja wierszy za pomoc list i wycinkw indeksw
oceny.loc['Algebra':'Statystyka']
oceny.iloc[0:2]
oceny.loc[['Algebra', 'Statystyka']]
oceny.iloc[[0, 2]]

#### 7.15.2.6. Selekcja podzbiorw wierszy i kolumn
oceny.loc['Algebra':'Programowanie', ['Ewa', 'Katarzyna']]
oceny.iloc[[0, 2], 0:3]

#### 7.15.2.7. Indeksowanie boolowskie
oceny[oceny >= 90]
oceny[(oceny >= 80) & (oceny < 90)]
import numpy as np
stopnie = np.array([75, 91, 93, 87, 99, 91, 88])
stopnie[stopnie >= 90]
         
#### 7.15.2.8. Dostp do poszczeglnych komrek ramki danych
oceny.at['Programowanie', 'Ewa']
oceny.iat[2, 0]
oceny.at['Programowanie', 'Ewa']
oceny.at['Programowanie', 'Ewa'] = 100
oceny.at['Programowanie', 'Ewa']
oceny.iat[1, 2]
oceny.iat[1, 2] = 87
oceny.iat[1, 2]

#### 7.15.2.9. Parametry statystyki opisowej dla ramki danych
oceny.describe()
pd.set_option('precision', 2)
oceny.describe()
oceny.mean()

#### 7.15.2.10. Transponowanie ramki danych  atrybut T
oceny.T
oceny.T.describe()
oceny.T.mean()
         
#### 7.15.2.11. Sortowanie wierszy wedug indeksw
oceny.sort_index(ascending=False)

#### 7.15.2.12. Sortowanie kolumn wedug indeksw 
oceny.sort_index(axis=1)

#### 7.15.2.13. Sortowanie kolumn wedug wartoci elementw wiersza
oceny.sort_values(by='Algebra', axis=1, ascending=False)
oceny.T.sort_values(by='Algebra', ascending=False)
oceny.loc['Algebra'].sort_values(ascending=False)
