﻿## 16.7. Strumieniowanie Sparka: zliczanie hashtagów przy użyciu „pyspark-notebook”
### 16.7.1. Uruchamianie kontenera i instalowanie biblioteki „Tweepy”
pip install tweepy

### 16.7.3. Uruchamianie skryptu w kontenerze
http://localhost:8888/lab
cd work/SparkHashtagSummarizer
ipython starttweetstream.py 10000 football

#### 16.7.3.1. Importowanie modułów
#### 16.7.4.1. Importowanie bibliotek
from pyspark import SparkContext
from pyspark.streaming import StreamingContext
from pyspark.sql import Row, SparkSession
from IPython import display
import matplotlib.pyplot as plt
import seaborn as sns
%matplotlib inline
--------------------------------
https://ipython.readthedocs.io/en/stable/interactive/magics.html

####16.7.4.2. Sesja — obiekt „SparkSession”
def getSparkSessionInstance(sparkConf):

  """Spark Streaming Programming Guide rekomenduje
     prezentowaną tu metodę uzyskiwania referencji 
     do istniejącego obiektu SparkSession lub tworzenie
     nowego obiektu tej klasy, gdy jeszcze takowy nie istnieje
     (obiekt ten jest singletonem)."""


   if ("sparkSessionSingletonInstance" not in globals()):
       globals()["sparkSessionSingletonInstance"] = SparkSession \
           .builder \
           .config(conf=sparkConf) \
           .getOrCreate()
   return globals()["sparkSessionSingletonInstance"]

#### 16.7.4.3. Wykres słupkowy na podstawie ramki DataFrame
def display_barplot(spark_df, x, y, time, scale=2.0, size=(16, 9)):
    """Wyświetlenie zawartości ramki Spark DataFrame 
       w postaci wykresu słupkowego"""
    df = spark_df.toPandas()
    
    # usunięcie poprzedniego wykresu w momencie, 
    # gdy nowy wykres stanie się gotowy do wyświetlenia
    display.clear_output(wait=True)
    print(f'CZAS: {time}')
    
    # utworzenie i skonfigurowanie obiektu Figure zawierającego 
    # nowy wykres
    plt.figure(figsize=size)
    sns.set(font_scale=scale)
    barplot = sns.barplot(data=df, x=x, y=y
                          palette=sns.color_palette('cool', 20))

    # obrót etykiet na osi x o kąt prosty dla lepszej czytelności
    for item in barplot.get_xticklabels():
        item.set_rotation(90)
        
    plt.tight_layout()
    plt.show()
    
#### 16.7.4.4. Czołówka 20 hashtagów
def count_tags(time, rdd):
    """Zliczanie hashtagów i wyświetlanie 20 najliczniejszych
       w kolejności malejącej"""
    try:
        # dostęp do obiektuSparkSession
        spark = getSparkSessionInstance(rdd.context.getConf())         

# mapowanie hashtagów postaci łańcuch-licznik na wiersze Row
rows = rdd.map(
    lambda tag: Row(hashtag=tag[0], total=tag[1]))

# utworzenie ramki DataFrame na podstawie kolekcji wierszy
hashtags_df = spark.createDataFrame(rows)

# utworzenie tymczasowego widoku ramki, do użytku przez Spark SQL
hashtags_df.createOrReplaceTempView('hashtags')

# wybór 20 najliczniejszych hashtagów posortowanych malejąco
top20_df = spark.sql(
    """select hashtag, total
       from hashtags
       order by total, hashtag desc
       limit 20""")

    display_barplot(top20_df, x='hashtagi', y='licznik', time=time)
except Exception as e:
    print(f'Błąd: {e}')

#### 16.7.4.5. Kontekst — obiekt „SparkContext”
sc = SparkContext()

#### 16.7.4.6. Strumieniowanie — obiekt „StreamingContext”
ssc = StreamingContext(sc, 10)
--------------------------------
https://spark.apache.org/docs/latest/streaming-programming-guide.html#performance-tuning

#### 16.7.4.7. Zarządzanie stanem — punkty kontrolne
ssc.checkpoint('hashtagsummarizer_checkpoint')
--------------------------------
https://spark.apache.org/docs/latest/streaming-programming-guide.html#checkpointing

#### 16.7.4.8. Połączenie ze strumieniem przez gniazdo
stream = ssc.socketTextStream('localhost', 9876)

#### 16.7.4.9. Tokenizacja łańcucha hashtagów
tokenized = stream.flatMap(lambda line: line.split())

#### 16.7.4.10. Mapowanie hashtagów w krotki „hashtag-licznik” 
mapped = tokenized.map(lambda hashtag: (hashtag, 1))

#### 16.7.4.11. Sumowanie liczników
hashtag_counts = tokenized.updateStateByKey(
    lambda counts, prior_total: sum(counts) + (prior_total or 0))

#### 16.7.4.12. Metoda wywoływana dla każdego RDD
hashtag_counts.foreachRDD(count_tags)

#### 16.7.4.13. Rozpoczęcie strumieniowania
ssc.start() # rozpoczęcie strumieniowania Sparka
