﻿## 9.12. Wprowadzenie do Data Science: przetwarzanie plików CSV
#### 9.12.1.1. Zapis do pliku CSV
import csv

with open('accounts.csv', mode='w', newline='') as accounts:
    writer = csv.writer(accounts)
    writer.writerow([100, 'Jones', 24.98])
    writer.writerow([200, 'Doe', 345.67])
    writer.writerow([300, 'White', 0.00])
    writer.writerow([400, 'Stone', -42.16])
    writer.writerow([500, 'Rich', 224.62])    
                    ])
#### 9.12.1.2. Odczyt z pliku CSV
with open('accounts.csv', 'r', newline='') as accounts:
    print(f'{"Nr konta":<10}{"Nazwa":<10}{"Stan konta":>10}')
    reader = csv.reader(accounts)

    for rekord in reader:
        nr_konta, nazwa, stan_konta = rekord
        print(f'{nr_konta:<10}{nazwa:<10}{stan_konta:>10}')

   
#### 9.12.1.4. Uwaga na pominięte, błędne i nadmiarowe przecinki
with open('accounts-bad-comma.csv', mode='w', newline='') as accounts:
    writer = csv.writer(accounts)
    writer.writerow([100, 'Jones', 24,98])
    writer.writerow([200, 'Doe', 345,67])
    writer.writerow([300, 'White', 0,00])
    writer.writerow([400, 'Stone', -42,16])
    writer.writerow([500, 'Rich', 224,62])    
--------------------------------
with open('accounts-bad-comma.csv', mode='w', newline='') as accounts:
    writer = csv.writer(accounts, delimiter=';')
    writer.writerow([100, 'Jones', '24,98'])
    writer.writerow([200, 'Doe', '345,67'])
    writer.writerow([300, 'White', '0,00'])
    writer.writerow([400, 'Stone', '-42,16'])
    writer.writerow([500, 'Rich', '224,62'])    

#### 9.12.2.2. Praca z lokalnymi plikami CSV
import pandas as pd

df = pd.read_csv('accounts.csv',
    names=['nr_konta', 'nazwa', 'stan_konta'])

df

df.to_csv('accounts_from_dataframe.csv', index=False)

#### 9.12.3.1. Wczytywanie listy pasażerów
import pandas as pd

titanic = pd.read_csv('https://vincentarelbundock.github.io/' +
                      'Rdatasets/csv/carData/TitanicSurvival.csv')
pd.set_option('precision', 2) # liczby rzeczywiste z 2 miejscami dziesiętnymi

titanic.head()

titanic.tail()

#### 9.12.3.2. Dostosowanie nazw kolumn
titanic.columns = ['Nazwisko i imię', 'Ocalały?', 'Płeć', 'Wiek', 'Klasa']
titanic.head()
titanic.describe()
--------------------------------
(titanic['Ocalały?'] == 'yes').describe()

#### 9.12.3.4 . Histogram wieku pasażerów
%matplotlib
histogram = titanic.hist()
