# tweetlistener.py
#-*- coding: 1250 -*-
"""Podklasa klasy bazowej tweepy.StreamListener 
   przechwytujca nadchodzce tweety
   i zapisujca je w bazie MongoDB."""

import tweepy
import json

class TweetListener(tweepy.StreamListener):
    """Obsuga strumienia nadchodzcych tweetw"""

    def __init__(self, api, database, limit=10000):
        """Utworzenie zmiennych obiektu kontrolujcych liczb tweetw."""

        self.db = database
        self.tweet_count = 0
        self.TWEET_LIMIT = limit  # domylnie 10,000
        super().__init__(api)  # wywoanie __init__ z nadklasy 

    def on_connect(self):
        """Metoda wywoywana, gdy poczenie zostaje pomylnie
           nawizane. Moliwe staje si wykonywanie zada wymagajcych 
           tego poczenia"""
        print('Nawizano poczenie\n')

    def on_data(self, data):
        """Metoda wywoywana, gdy Twitter dostarcza nowy tweet"""
        self.tweet_count += 1  # kontrola liczby przetworzonych tweetw
        json_data = json.loads(data)  # konwersja surowych danych na dokument JSON
        self.db.tweets.insert_one(json_data)  # dodanie tweetu do kolekcji
        
        # bezpieczne odczytanie atrybutw tweetu
        # gdy ktra z wartoci jest nieobecna, nie pojawia si nieobsuony wyjtek
        # powodujcy przerwanie przechwytywania

        try:
            konto = json_data["user"]["name"]
        except:
            konto = '???'
        
        try:
            utworzony = json_data["created_at"]
        except:
            utworzony = '???'

        print(f'            Konto: {konto}') 
        print(f'        Utworzony: {utworzony}')         
        print(f'Otrzymano tweetw: {self.tweet_count}')         

        # gdy osignity zostanie limit liczby tweetw, zwrc FALSE,
        # w przeciwnym razie zwrc TRUE
        return self.tweet_count < self.TWEET_LIMIT
    
    def on_error(self, status):
        print(f'Bd: {status}')
        return True

##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
