# akwizytor.py
#-*- coding: 1250 -*-
"""Klasa bazowa Akwizytor"""
from decimal import Decimal

class Akwizytor:
    """Pracownik, ktrego wynagrodzenie jest wycznie prowizj od sprzeday"""
    def __init__(self, imie, nazwisko, nr_ubezpieczenia, 
                 sprzedaz, prowizja):
        """Inicjowanie atrybutw."""
        self._imie = imie
        self._nazwisko = nazwisko
        self._nr_ubezpieczenia = nr_ubezpieczenia
        self.sprzedaz = sprzedaz  # walidacja w ramach waciwoci
        self.prowizja = prowizja  # walidacja w ramach waciwoci

    @property
    def imie(self):
        return self._imie

    @property
    def nazwisko(self):
        return self._nazwisko

    @property
    def nr_ubezpieczenia(self):
        return self._nr_ubezpieczenia

    @property
    def sprzedaz(self):
        return self._sprzedaz

    @sprzedaz.setter
    def sprzedaz(self, kwota):
        """Walidacja wartoci sprzeday."""
        if kwota < Decimal('0.00'):
            raise ValueError('Warto sprzeday nie moe by ujemna')
        
        self._sprzedaz = kwota
        
    @property
    def prowizja(self):
        return self._prowizja

    @prowizja.setter
    def prowizja(self, procent):
        """Walidacja wysokoci prowizji"""
        if not (Decimal('0.0') < procent < Decimal('100.0')):
            raise ValueError(
               'Prowizja nie moe by ujemna i nie moe przekracza 100%')
        
        self._prowizja = procent

    def zarobek(self):
        """Obliczenie wynagrodzenia."""    
        return self.sprzedaz * (self.prowizja/Decimal('100.0'))

    def __repr__(self):
        """Reprezentacja tekstowa obiektu."""
        return ('Akwizytor: ' + 
            f'{self.imie} {self.nazwisko}\n' +
            f'numer ubezpieczenia: {self.nr_ubezpieczenia}\n' +
            f'sprzeda: {self.sprzedaz:.2f}\n' +
            f'prowizja: {self.prowizja:.2f}%')



##########################################################################
# (C) Copyright 2019 by Deitel & Associates, Inc. and                    #
# Pearson Education, Inc. All Rights Reserved.                           #
#                                                                        #
# DISCLAIMER: The authors and publisher of this book have used their     #
# best efforts in preparing the book. These efforts include the          #
# development, research, and testing of the theories and programs        #
# to determine their effectiveness. The authors and publisher make       #
# no warranty of any kind, expressed or implied, with regard to these    #
# programs or to the documentation contained in these books. The authors #
# and publisher shall not be liable in any event for incidental or       #
# consequential damages in connection with, or arising out of, the       #
# furnishing, performance, or use of these programs.                     #
##########################################################################
