# Rozdzia 15. Gbokie uczenie
### 15.6.4. Wczytanie zbioru MNIST 
from tensorflow.keras.datasets import mnist 
(X_train, y_train), (X_test, y_test) = mnist.load_data()

### 15.6.5. Eksploracja danych
X_train.shape
y_train.shape
X_test.shape
y_test.shape

#### 15.6.5.1. Wizualizacja cyfr
%matplotlib
import matplotlib.pyplot as plt
import seaborn as sns
sns.set(font_scale=2)

import numpy as np
index = np.random.choice(np.arange(len(X_train)), 24, replace=False)
figure, axes = plt.subplots(nrows=4, ncols=6, figsize=(16, 9))
for item in zip(axes.ravel(), X_train[index], y_train[index]):
    axes, image, target = item
    axes.imshow(image, cmap=plt.cm.gray_r)
    axes.set_xticks([]) # usunicie znacznikw z osi x
    axes.set_yticks([]) # usunicie znacznikw z osi y
    axes.set_title(target)
plt.tight_layout()

#### 15.6.6.1. Zmiana struktury danych
X_train = X_train.reshape((60000, 28, 28, 1))
X_train.shape
X_test = X_test.reshape((10000, 28, 28, 1))
X_test.shape

#### 15.6.6.2. Normalizacja danych
X_train = X_train.astype('float32') / 255
X_test = X_test.astype('float32') / 255

#### 15.6.6.3. Kodowanie z gorc jedynk: konwersja liczb cakowitych na dane kategoryczne
from tensorflow.keras.utils import to_categorical
y_train = to_categorical(y_train)
y_train.shape
y_train[0]
y_test = to_categorical(y_test)
y_test.shape

### 15.6.7. Budowanie sieci neuronowej
from tensorflow.keras.models import Sequential
cnn = Sequential()

#### 15.6.7.1. Dodawanie warstw do sieci
from tensorflow.keras.layers import Conv2D, Dense, Flatten,MaxPooling2D

##### 15.6.7.1.2. Dodawanie warstwy konwolucji
cnn.add(Conv2D(filters=64, kernel_size=(3, 3), activation='relu', 
               input_shape=(28, 28, 1)))

##### 15.6.7.1.5. Dodawanie warstwy czcej
cnn.add(MaxPooling2D(pool_size=(2, 2)))

##### 15.6.7.1.6. Dodawanie kolejnych warstw: konwolucyjnej i czcej
cnn.add(Conv2D(filters=128, kernel_size=(3, 3), activation='relu'))
cnn.add(MaxPooling2D(pool_size=(2, 2)))

##### 15.6.7.1.7. Spaszczanie wynikw
cnn.add(Flatten())

##### 15.6.7.1.8. Dodawanie warstwy gstej w celu redukcji liczby cech
cnn.add(Dense(units=128, activation='relu'))

##### 15.6.7.1.9. Dodawanie kolejnej warstwy gstej produkujcej wynik klasyfikacji
cnn.add(Dense(units=10, activation='softmax'))

##### 15.6.7.1.10. Podsumowanie modelu
cnn.summary()

##### 15.6.7.1.11. Wizualizacja struktury modelu
from tensorflow.keras.utils import plot_model
from IPython.display import Image
plot_model(cnn, to_file='convnet.png', show_shapes=True,
           show_layer_names=True)

Image(filename='convnet.png')

##### 15.6.7.1.12. Kompilowanie modelu
cnn.compile(optimizer='adam',
            loss='categorical_crossentropy',
            metrics=['accuracy'])

---------
from tensorflow.keras.callbacks import TensorBoard import time
tensorboard_callback = TensorBoard(log_dir=f'./logs/mnist{time.time()}',
    histogram_freq=1, write_graph=True)
---------

### 15.6.8. Trenowanie i ewaluacja modelu
cnn.fit(X_train, y_train, epochs=5, batch_size=64,
        validation_split=0.1)

#### 15.6.8.1. Ewaluacja
loss, accuracy = cnn.evaluate(X_test, y_test)
loss
accuracy

#### 15.6.8.2. Prognozowanie
przypuszczenia = cnn.predict(X_test)
y_test[0]
for indeks, przypuszczenie in enumerate(przypuszczenia[0]):
    print(f'{indeks}: { przypuszczenie:.10%}')


#### 15.6.8.3. Wyszukiwanie chybionych prognoz
obrazy = X_test.reshape((10000, 28, 28))
chybione_prognozy = []
      
for i, (p, e) in enumerate(zip(przypuszczenia, y_test)):
    prognozowany, spodziewany = np.argmax(p), np.argmax(e)

    if prognozowany != spodziewany:
        chybione_prognozy.append(
            (i, obrazy[i], prognozowany, spodziewany))
            
len(chybione_prognozy)


#### 15.6.8.4. Wizualizacja chybionych prognoz
figure, axes = plt.subplots(nrows=4, ncols=6, figsize=(16, 12))

for axes, element in zip(axes.ravel(), chybione_prognozy):
    indeks, obraz, prognozowany, spodziewany = element
    axes.imshow(obraz, cmap=plt.cm.gray_r)
    axes.set_xticks([]) # usu znaczniki z osi x
    axes.set_yticks([]) # usu znaczniki z osi y
    axes.set_title(
        f'indeks: {indeks}\np: {prognozowany}; s: {spodziewany}')

plt.tight_layout()

#### 15.6.8.5. Szczegy niektrych chybionych prognoz
def wypisz_przypuszczenia(prognoza):
    for indeks, przypuszczenie in enumerate(prognoza):
        print(f'{indeks}: {przypuszczenie:.10%}')

wypisz_przypuszczenia(przypuszczenia[495])

wypisz_przypuszczenia(przypuszczenia[583])

wypisz_przypuszczenia(przypuszczenia[625])

### 15.6.9. Zapisywanie i adowanie modelu
cnn.save('mnist_cnn.h5')

from tensorflow.keras.models import load_model
cnn = load_model('mnist_cnn.h5')
