﻿## 12.13. Strumieniowanie tweetów — Twitter Streaming API
#### 12.13.2.1. Uwierzytelnianie
import tweepy
import keys
auth = tweepy.OAuthHandler(keys.consumer_key,
                           keys.consumer_secret)

auth.set_access_token(keys.access_token,
                      keys.access_token_secret)

api = tweepy.API(auth, wait_on_rate_limit=True,
                 wait_on_rate_limit_notify=True)

#### 12.13.2.2. Tworzenie obiektu „TweetListener”
from tweetlistener import TweetListener
tweet_listener = TweetListener(api)

#### 12.13.2.3. Tworzenie strumienia 
tweet_stream = tweepy.Stream(auth=api.auth,
                  listener=tweet_listener)

#### 12.13.2.4. Uruchomienie strumieniowania
tweet_stream.filter(track=['Mars Rover'], is_async=True)
