﻿# fig06_02.py

"""Zliczanie występowania słów w tekście."""

tekst = ('to jest przykładowy tekst składający się z kilku słów '
         'to jest inny przykładowy tekst zawierający większą liczbę słów')  

liczniki = {}

# zliczanie wystąpień unikalnych słów
for wyraz in tekst.split():
    if wyraz in liczniki: 
        liczniki[wyraz] += 1  # zwiększ licznik zarejestrowanego już słowa
    else:
        liczniki[wyraz] = 1  # zarejestruj nowe słowo

print(f' {"SŁOWO":<25}LICZNIK')

wielokrotne = 0
for wyraz, licznik in sorted(liczniki.items()):
    if licznik > 1:
        wielokrotne += 1
    print(f'  {wyraz:<25}{licznik}')

print('\nLiczba unikalnych słów:', len(liczniki))
print('Liczba słów występujących wielokrotnie:', wielokrotne)
