# Rozdzia 6. Sowniki i zbiory
## 6.2. Sowniki
### 6.2.2. Tworzenie sownika
domeny_krajowe = {'Polska': 'pl', 'Finlandia': 'fi', 'Nepal': 'np'}
domeny_krajowe

### 6.2.3. Czy sownik jest pusty?
len(domeny_krajowe)
domeny_galaktyczne = {}

if domeny_krajowe:
    print(domeny_krajowe)
else:
    print('Sownik jest pusty')    

if domeny_galaktyczne:
    print(domeny_galaktyczne)
else:
    print('Sownik jest pusty')
--------------------------------
domeny_krajowe.clear()

if domeny_krajowe:
    print(domeny_krajowe)
else:
    print('Sownik jest pusty')
    
### 6.2.4. Iterowanie po elementach sownika
dni_w_mcu = {'Stycze':31, 'Luty':28, 'Marzec':31}  
dni_w_mcu
--------------------------------
for mc, dni in dni_w_mcu.items():
    print(f'{mc} ma {dni} dni')

### 6.2.5. Podstawowe operacje na sownikach
liczby_rzymskie = {'I': 1, 'II': 2, 'III': 3, 'V': 5, 'X': 100}
liczby_rzymskie

#### 6.2.5.1. Dostp do wartoci na podstawie skojarzonego klucza
liczby_rzymskie['V']

#### 6.2.5.2. Aktualizacja wartoci skojarzonej z kluczem
liczby_rzymskie['X'] = 10
liczby_rzymskie

#### 6.2.5.3. Dodawanie nowego elementu
liczby_rzymskie['L'] = 50
liczby_rzymskie
 
#### 6.2.5.4. Usuwanie elementu
del liczby_rzymskie['III']
liczby_rzymskie
element = liczby_rzymskie.pop('X')
element

#### 6.2.5.5. Prba dostpu do nieistniejcego klucza
liczby_rzymskie['III']
--------------------------------
element = liczby_rzymskie.get('III')
element
element = liczby_rzymskie.get('III', 'Brak klucza \'III\' w sowniku')
element

#### 6.2.5.6. Testowanie obecnoci klucza w sowniku
'V' in liczby_rzymskie
'III' in liczby_rzymskie
'III' not in liczby_rzymskie

### 6.2.6. Metody keys i values
m_ce = {'Stycze': 1, 'Luty': 2, 'Marzec': 3}

for mc_nazwa in m_ce.keys():
    print(mc_nazwa, end=' ')

for mc_nr in m_ce.values():
    print(mc_nr, end=' ')

#### 6.2.6.1. Widoki sownikw
mc_klucze = m_ce.keys()
for klucz in mc_klucze:
    print(klucz, end=' ')  

m_ce['Grudzie'] = 12
m_ce

for klucz in mc_klucze:
    print(klucz, end=' ')    

#### 6.2.6.2. Konwertowanie kluczy, wartoci i elementw na listy
m_ce

lista_klucze = list(m_ce.keys())
lista_numery = list(m_ce.values())
lista_elementy = list(m_ce.items())
print(lista_klucze, lista_numery, lista_elementy, sep='\n')

m_ce['Kwiecie'] = 4
del m_ce['Luty']
m_ce

print(lista_klucze, lista_numery, lista_elementy, sep='\n')

#### 6.2.6.3. Przetwarzanie kluczy w kolejnoci rosncej
for mc_nazwa in sorted(m_ce.keys()):
    print(mc_nazwa, ':', m_ce[mc_nazwa], sep = '', end='  ')

### 6.2.7. Porwnywanie sownikw
stolice_1 = {'Belgia': 'Bruksela',
             'Haiti': 'Port-au-Prince'}

stolice_2 = {'Nepal': 'Kathmandu',
             'Urugwaj': 'Montevideo'}
 
stolice_3 = {'Haiti': 'Port-au-Prince',
             'Belgia': 'Bruksela'}    

stolice_1 == stolice_2

stolice_1 == stolice_3

stolice_1 != stolice_2

### 6.2.8. Przykad: dziennik ocen jako sownik 
run fig06_01.py

### 6.2.9. Przykad: zliczanie sw
run fig06_02.py

#### 6.2.9.1. Modu collections biblioteki standardowej
run fig06_02_counter.py

### 6.2.10. Metoda update
domeny_krajowe = {}
domeny_krajowe.update({'Poudniowa Afryka': 'za'})
domeny_krajowe

domeny_krajowe.update(Australia='ar')
domeny_krajowe

domeny_krajowe.update(Australia='au')
domeny_krajowe

### 6.2.11. Odwzorowywanie sownikw
m_ce_numery = {'Stycze': 1, 'Luty': 2, 'Marzec': 3}
m_ce_nazwy = {nr: nazwa for nazwa, nr in m_ce_numery.items()}
m_ce_nazwy
--------------------------------
punktacje = {'Zuzanna': [98, 87, 94], 'Bogdan': [84, 95, 91]}
wyniki = {klucz: sum(oceny) / len(oceny) for klucz, oceny in punktacje.items()}
wyniki
