
# Kod z rozdziału 05 - Debugowanie za pomocą instrukcji print

# Z BŁĘDAMI!
# Ten kod zawiera dwa defekty.

from pygame import image, Surface
from load_tiles import load_tiles, get_tile_rect, SIZE
from generate_maze import create_maze


def parse_grid(data):
    """Parsuje reprezentację tekstową do postaci zagnieżdżonej listy"""
    return data.strip().split('\n')


def draw_grid(data, tile_img, tiles):
    """Zwraca obraz siatki złożonej z kafelków"""
    xs = len(data[0]) * SIZE
    ys = len(data) * SIZE
    img = Surface((xs, ys))
    for y, row in enumerate(data):
        for x, char in enumerate(row):
            rect = get_tile_rect(xs, ys)
            img.blit(tile_img, tiles[char], rect)
        return img


if __name__ == '__main__':
    tile_img, tiles = load_tiles()
    level = create_maze(12, 7)
    level = parse_grid(level)
    maze = draw_grid(level, tile_img, tiles)
    image.save(maze, 'maze.png')