from collections import deque
import itertools

def moving_average(iterable, n=3):
    # moving_average([40, 30, 50, 46, 39, 44]) --> 40.0 42.0 45.0 43.0
    # https://pl.wikipedia.org/wiki/Średnia_ruchoma
    it = iter(iterable)  # Utworzenie iterowalnego obiektu na podstawie danych wejściowych
    d = deque(itertools.islice(it, n-1))  # Utworzenie obiektu kolejki za pomocą wycinka iterowanego obiektu
    d.appendleft(0)
    s = sum(d)
    for elem in it:
        s += elem - d.popleft()
        d.append(elem)
        yield s / n  # Polecenie yield przypomina polecenie "return", ale jest używane wraz z generatorami

ma = moving_average([40, 30, 50, 46, 39, 44])
next(ma)
next(ma)
next(ma)
