"""
Moduł Factorial

Ten moduł definiuje własną funkcję factorial() (ignorując istnienie w Pythonie funkcji math.factorial()).
Na przykład:

>>> factorial(4)
24
"""

def factorial(n):
    """Zwraca silnię n.

    Zwykła pętla:
    >>> for n in range(4): print(factorial(n))
    1
    1
    2
    6
	
	Lista składana:
	>>> [factorial(n) for n in range(6)]
        [1, 1, 2, 6, 24, 120]
	
	Zwykła silnia:
    >>> factorial(25)
    15511210043330985984000000

	Przykład użycia wartości ujemnej:
    >>> factorial(-3)
    Traceback (most recent call last):
        ...
    ValueError: Wartość musi wynosić przynajmniej 0.

    Wartość zmiennoprzecinkowa musi się kończyć zerem:
    >>> factorial(25.1)
    Traceback (most recent call last):
        ...
    ValueError: Wartość zmiennoprzecinkowa musi być odpowiednikiem liczby całkowitej.
    >>> factorial(25.0)
    15511210043330985984000000

    Wartość nie może być zbyt duża:
    >>> factorial(1e25)
    Traceback (most recent call last):
        ...
    OverflowError: Wartość jest zbyt duża.
    """

    import math
    if not n >= 0:
        raise ValueError("Wartość musi wynosić przynajmniej 0.")
    if math.floor(n) != n:
        raise ValueError("Wartość zmiennoprzecinkowa musi być odpowiednikiem liczby całkowitej.")
    if n+1 == n:  # Przechwytywanie wartości typu 1e100
        raise OverflowError("Wartość jest zbyt duża.")
    result = 1
    factor = 2
    while factor <= n:
        result *= factor
        factor += 1
    return result


if __name__ == "__main__":
    import doctest
    print(doctest.__file__)
    doctest.testmod()
