>>> from collections import OrderedDict
>>> d = {'banan': 3, 'jabłko': 4, 'gruszka': 1, 'pomarańcza': 2} # Zwykły nieposortowany słownik

>>> OrderedDict(sorted(d.items(), key=lambda t: t[0]))
OrderedDict([('banan', 3), ('gruszka', 1), ('jabłko', 4), ('pomarańcza', 2)]) # Słownik sortowany według klucza

>>> OrderedDict(sorted(d.items(), key=lambda t: t[1]))
OrderedDict([('gruszka', 1), ('pomarańcza', 2), ('banan', 3), ('jabłko', 4)]) # Słownik sortowany według wartości

>>> OrderedDict(sorted(d.items(), key=lambda t: len(t[0])))
OrderedDict([('banan', 3), ('jabłko', 4), ('gruszka', 1), ('pomarańcza', 2)]) # Słownik sortowany według długości ciągu tekstowego klucza

