import asyncio

async def feed(reader):
  while (data := await reader.read(1024)):
    yield data

async def polaczenie(reader, writer):
  print('Połączono')
  async for data in (b'>>> '+i async for i in feed(reader)):
    print (f'Odebrano: {data.decode().strip()}')
    writer.write(data)
    await writer.drain()
    print (f'Wysłano: {data.decode().strip()}')
  print('Zakończono połączenie')

async def main():
  server = await asyncio.start_server(polaczenie,host='localhost',port=4444)
  async with server:
    await server.serve_forever()
  print('Zamykamy')

asyncio.run(main())

