import asyncio

async def say_after(what,when):
  await asyncio.sleep(when)
  return what

async def hello(x,name):
  try:
    print (await say_after (f"{name}: Witaj!...", 0.))
    print (await say_after (f"{name}: Po czasie {x}... Żegnaj!", x))
    if name=='przedkoniec':
      asyncio.create_task(hello(2.,'koniec'))
    elif name!='koniec':
      asyncio.create_task(hello(2.,'przedkoniec'))
  except asyncio.CancelledError:
    print(f'{name}: Po żadaniu anulowania - sprzątam po sobie i kończę działanie')
    raise asyncio.CancelledError

async def main():
  await asyncio.gather(hello(2.,'1'),hello(1.,'2'))
  while True:
    tasks = asyncio.all_tasks()
    tasks = [t for t in tasks if t is not asyncio.current_task() ]	# w przeciwnym razie czekałby też na samego siebie
    if not tasks:
      break
    await asyncio.gather(*tasks,return_exceptions=True)

asyncio.run(main())
