import numpy as np
from matplotlib import pyplot as plt

N=50; dx=2./N; dt = .25 * dx**2/2
x=np.linspace(-2,2,N+1)[:-1];
y=np.linspace(-2,2,N+1)[:-1];
x,y=np.meshgrid(x,y)

imax=50000

# Laplasjan
def L(z):
  return (z[:-2,1:-1]+z[2:,1:-1]+z[1:-1,:-2]+z[1:-1,2:]-4*z[1:-1,1:-1])/dx**2

# Prawa strona równania różniczkowego
a = 4e-4; b = 2e-3; tau = .2; k = -.005
def f(u,v):
  return ( dt*( a*L(u) + (u-u**3-v+k)[1:-1,1:-1] ), dt*( b*L(v) + (u-v)[1:-1,1:-1])/tau )

# Inicjalizacja
u=np.random.random(x.shape)
v=np.random.random(x.shape)

for j in range(imax):
  du,dv=f(u,v)
  u[1:-1,1:-1]+=du
  v[1:-1,1:-1]+=dv
  # warunki znikania pochodnej na brzegu
  u[0,:]=u[1,:]; u[-1,:]=u[-2,:]
  u[:,0]=u[:,1]; u[:,-1]=u[:,-2]
  v[0,:]=v[1,:]; v[-1,:]=v[-2,:]
  v[:,0]=v[:,1]; v[:,-1]=v[:,-2]

plt.imshow(u,cmap='copper')
plt.show()
