import asyncio

async def polaczenie(reader, writer):
  print('Połączono')
  while True:
    data = await reader.read(1024)
    print (f'Odebrano: {data.decode().strip()}')
    if not data:
      writer.close()
      await writer.wait_closed()
      print('Zakończono połączenie')
      break
    writer.write(data)
    await writer.drain()
    print (f'Wysłano: {data.decode().strip()}')

async def main():
  server = await asyncio.start_server(polaczenie,host='localhost',port=4444)
  async with server:
    await server.serve_forever()
  print('Zamykamy')

asyncio.run(main())
