# coding: utf-8


import tensorflow as tf
import numpy as np
import matplotlib.pyplot as plt
import sys
import gzip
import shutil
import os
import struct
import tensorflow.contrib.keras as keras

# *Python. Uczenie maszynowe. Wydanie drugie*, [Sebastian Raschka](https://sebastianraschka.com), Packt Publishing Ltd. 2017
# 
# Repozytorium kodu: https://github.com/rasbt/python-machine-learning-book-2nd-edition
# 
# Licencja: [MIT License](https://github.com/rasbt/python-machine-learning-book-2nd-edition/blob/master/LICENSE.txt)

# # Python. Uczenie maszynowe - kod źródłowy

# # Chapter 13 - Parallelizing Neural Network Training with TensorFlow  

# - [Tworzenie, kompilowanie i uruchamianie wyrażeń w interfejsie TensorFlow](#Tworzenie,-kompilowanie-i-uruchamianie-wyrażeń-w-interfejsie-TensorFlow)
#   - [Problemy ze skutecznością w przypadku kosztownych obliczeń](#Problemy-ze-skutecznością-w-przypadku-kosztownych-obliczeń)
#   - [Czym jest biblioteka TensorFlow?](#Czym-jest-biblioteka-TensorFlow?)
#   - [Pierwsze kroki z biblioteką TensorFlow](#Pierwsze-kroki-z-biblioteką-TensorFlow)
#   - [Praca ze strukturami tablicowymi](#Praca-ze-strukturami-tablicowymi)
#   - [Tworzenie prostego modelu za pomocą podstawowego interfejsu TensorFlow](#Tworzenie-prostego-modelu-za-pomocą-podstawowego-interfejsu-TensorFlow)
# - [Skuteczne uczenie sieci neuronowych za pomocą wyspecjalizowanych interfejsów biblioteki TensorFlow](#Skuteczne-uczenie-sieci-neuronowych-za-pomocą-wyspecjalizowanych-interfejsów-biblioteki-TensorFlow)
#   - [Tworzenie wielowarstwowych sieci neuronowych za pomocą interfejsu Layers](#Tworzenie-wielowarstwowych-sieci-neuronowych-za-pomocą-interfejsu-Layers)
#   - [Projektowanie wielowarstwowej sieci neuronowej za pomocą interfejsu Keras](#Projektowanie-wielowarstwowej-sieci-neuronowej-za-pomocą-interfejsu-Keras)
# - [Dobór funkcji aktywacji dla wielowarstwowych sieci neuronowych](#Dobór-funkcji-aktywacji-dla-wielowarstwowych-sieci-neuronowych)
#   - [Funkcja logistyczna — powtórzenie](#Funkcja-logistyczna-—-powtórzenie)
#   - [Szacowanie prawdopodobieństw przynależności do klas w klasyfikacji wieloklasowej za pomocą funkcji softmax](#Szacowanie-prawdopodobieństw-przynależności-do-klas-w-klasyfikacji-wieloklasowej-za-pomocą-funkcji-softmax)
#   - [Rozszerzanie zakresu wartości wyjściowych za pomocą funkcji tangensa hiperbolicznego](#Rozszerzanie-zakresu-wartości-wyjściowych-za-pomocą-funkcji-tangensa-hiperbolicznego)
#   - [Aktywacja za pomocą prostowanej jednostki liniowej](#Aktywacja-za-pomocą-prostowanej-jednostki-liniowej)
# - [Podsumowanie](#Podsumowanie)

# Zwróć uwagę, że rozszerzenie zawierające nieobowiązkowy znak wodny stanowi niewielki plugin notatnika IPython / Jupyter, który zaprojektowałem w celu powielania kodu źródłowego. Wystarczy pominąć poniższe wiersze kodu:





# *Korzystanie z rozszerzenia `watermark` nie jest obowiązkowe. Możesz je zainstalować za pomocą polecenia "`pip install watermark`". Więcej informacji na jego temat znajdziesz pod adresem: https://github.com/rasbt/watermark.*









# ## Tworzenie, kompilowanie i uruchamianie wyrażeń w interfejsie TensorFlow

# ### Problemy ze skutecznością w przypadku kosztownych obliczeń





# ### Czym jest biblioteka TensorFlow?

# ### Pierwsze kroki z biblioteką TensorFlow




## tworzy graf
g = tf.Graph()
with g.as_default():
    x = tf.placeholder(dtype=tf.float32,
                       shape=(None), name='x')
    w = tf.Variable(2.0, name='waga')
    b = tf.Variable(0.7, name='obciazenie')

    z = w*x + b
    init = tf.global_variables_initializer()

## tworzy sesję i wstawia do niej graf g
with tf.Session(graph=g) as sess:
    ## initialize w and b:
    sess.run(init)
    ## evaluate z:
    for t in [1.0, 0.6, -1.8]:
        print('x=%4.1f --> z=%4.1f'%(
              t, sess.run(z, feed_dict={x:t})))




with tf.Session(graph=g) as sess:
    sess.run(init)
    print(sess.run(z, feed_dict={x:[1., 2., 3.]})) 


# ### Praca ze strukturami tablicowymi





g = tf.Graph()
with g.as_default():
    x = tf.placeholder(dtype=tf.float32, 
                       shape=(None, 2, 3),
                       name='wejscie_x')

    x2 = tf.reshape(x, shape=(-1, 6),
                    name='x2')

    ## oblicza sumę każdej kolumny
    xsum = tf.reduce_sum(x2, axis=0, name='suma_kol')

    ## oblicza wartość średnią każdej kolumny
    xmean = tf.reduce_mean(x2, axis=0, name='srednia_kol')

    
with tf.Session(graph=g) as sess:
    x_array = np.arange(18).reshape(3, 2, 3)
    print('Wymiary wejściowe: ', x_array.shape)
    print('Przekształcone:\n', 
          sess.run(x2, feed_dict={x:x_array}))
    print('Sumy kolumn:\n', 
          sess.run(xsum, feed_dict={x:x_array}))
    print('Średnie kolumn:\n', 
          sess.run(xmean, feed_dict={x:x_array}))


# ### Tworzenie prostego modelu za pomocą podstawowego interfejsu TensorFlow



 
X_train = np.arange(10).reshape((10, 1))
y_train = np.array([1.0, 1.3, 3.1,
                    2.0, 5.0, 6.3, 
                    6.6, 7.4, 8.0, 
                    9.0])




class TfLinreg(object):
    
    def __init__(self, x_dim, learning_rate=0.01,
                 random_seed=None):
        self.x_dim = x_dim
        self.learning_rate = learning_rate
        self.g = tf.Graph()
        ## buduje model
        with self.g.as_default():
            ## wyznacza ziarno losowości dla grafu
            tf.set_random_seed(random_seed)
            
            self.build()
            ## tworzy inicjator
            self.init_op = tf.global_variables_initializer()
        
    def build(self):
        ## definiuje węzły zastępcze dla danych wejściowych
        self.X = tf.placeholder(dtype=tf.float32,
                                shape=(None, self.x_dim),
                                name='x_wejscie')
        self.y = tf.placeholder(dtype=tf.float32,
                                shape=(None),
                                name='y_wejscie')
        print(self.X)
        print(self.y)
        ## definiuje macierz wag i wektor obciążenia
        w = tf.Variable(tf.zeros(shape=(1)),
                        name='waga')
        b = tf.Variable(tf.zeros(shape=(1)), 
                        name="obciazenie")
        print(w)
        print(b)

        self.z_net = tf.squeeze(w*self.X + b,
                                name='z_pobudzenie')
        print(self.z_net)
        
        sqr_errors = tf.square(self.y - self.z_net, 
                               name='bld_kwadratowe')
        print(sqr_errors)
        self.mean_cost = tf.reduce_mean(sqr_errors,
                                        name='sredni_koszt')
        
        optimizer = tf.train.GradientDescentOptimizer(
                    learning_rate=self.learning_rate, 
                    name='GradientProsty')
        self.optimizer = optimizer.minimize(self.mean_cost)




lrmodel = TfLinreg(x_dim=X_train.shape[1], learning_rate=0.01)




def train_linreg(sess, model, X_train, y_train, num_epochs=10):
    ## inicjuje wszystkie zmienne: W i b
    sess.run(model.init_op)
    
    training_costs = []
    for i in range(num_epochs):
        _, cost = sess.run([model.optimizer, model.mean_cost], 
                           feed_dict={model.X:X_train, 
                                      model.y:y_train})
        training_costs.append(cost)
        
    return training_costs




sess = tf.Session(graph=lrmodel.g)
training_costs = train_linreg(sess, lrmodel, X_train, y_train)





plt.plot(range(1,len(training_costs) + 1), training_costs)
plt.tight_layout()
plt.xlabel('Epoka')
plt.ylabel('Koszt uczenia')
#plt.savefig('rysunki/13_01.png', dpi=300)
plt.show()




def predict_linreg(sess, model, X_test):
    y_pred = sess.run(model.z_net, 
                      feed_dict={model.X:X_test})
    return y_pred




plt.scatter(X_train, y_train,
            marker='s', s=50,
            label='Dane uczące')
plt.plot(range(X_train.shape[0]), 
         predict_linreg(sess, lrmodel, X_train),
         color='gray', marker='o', 
         markersize=6, linewidth=3,
         label='Model regresji liniowej')
plt.xlabel('x')
plt.ylabel('y')
plt.legend()
plt.tight_layout()
#plt.savefig('rysunki/13_02.png')
plt.show()


# ## Skuteczne uczenie sieci neuronowych za pomocą wyspecjalizowanych interfejsów biblioteki TensorFlow

# ### Tworzenie wielowarstwowych sieci neuronowych za pomocą interfejsu Layers

# - Zestaw MNIST został dokładnie omówiony w rozdziale 12.



# rozpakowuje zestaw MNIST


if (sys.version_info > (3, 0)):
    writemode = 'wb'
else:
    writemode = 'w'

zipped_mnist = [f for f in os.listdir('./') if f.endswith('ubyte.gz')]
for z in zipped_mnist:
    with gzip.GzipFile(z, mode='rb') as decompressed, open(z[:-3], writemode) as outfile:
        outfile.write(decompressed.read())




 
def load_mnist(path, kind='train'):
    """Wczytuje zestaw danych MNIST umieszczony w katalogu zdefiniowanym w zmiennej `path`"""
    labels_path = os.path.join(path, 
                               '%s-labels-idx1-ubyte' % kind)
    images_path = os.path.join(path, 
                               '%s-images-idx3-ubyte' % kind)
        
    with open(labels_path, 'rb') as lbpath:
        magic, n = struct.unpack('>II', 
                                 lbpath.read(8))
        labels = np.fromfile(lbpath, 
                             dtype=np.uint8)

    with open(images_path, 'rb') as imgpath:
        magic, num, rows, cols = struct.unpack(">IIII", 
                                               imgpath.read(16))
        images = np.fromfile(imgpath, 
                             dtype=np.uint8).reshape(len(labels), 784)
        images = ((images / 255.) - .5) * 2
 
    return images, labels




## wczytywanie danych
X_train, y_train = load_mnist('.', kind='train')
print('Rzędy: %d, Kolumny: %d' %(X_train.shape[0], 
                                 X_train.shape[1]))

X_test, y_test = load_mnist('.', kind='t10k')
print('Rzędy: %d, Kolumny: %d' %(X_test.shape[0], 
                                     X_test.shape[1]))
## środkowanie do średniej i normalizacja:
mean_vals = np.mean(X_train, axis=0)
std_val = np.std(X_train)

X_train_centered = (X_train - mean_vals)/std_val
X_test_centered = (X_test - mean_vals)/std_val

del X_train, X_test

print(X_train_centered.shape, y_train.shape)

print(X_test_centered.shape, y_test.shape)





n_features = X_train_centered.shape[1]
n_classes = 10
random_seed = 123
np.random.seed(random_seed)

g = tf.Graph()
with g.as_default():
    tf.set_random_seed(random_seed)
    tf_x = tf.placeholder(dtype=tf.float32,
                       shape=(None, n_features),
                       name='tf_x')

    tf_y = tf.placeholder(dtype=tf.int32, 
                        shape=None, name='tf_y')
    y_onehot = tf.one_hot(indices=tf_y, depth=n_classes)

    h1 = tf.layers.dense(inputs=tf_x, units=50,
                         activation=tf.tanh,
                         name='warstwa1')

    h2 = tf.layers.dense(inputs=h1, units=50,
                         activation=tf.tanh,
                         name='warstwa2')

    logits = tf.layers.dense(inputs=h2, 
                             units=10,
                             activation=None,
                             name='warstwa3')

    predictions = {
        'classes' : tf.argmax(logits, axis=1, 
                              name='przewidywane_klasy'),
        'probabilities' : tf.nn.softmax(logits, 
                              name='tensor_softmax')
    }




## definiuje funkcję kosztu i optymalizator:
with g.as_default():
    cost = tf.losses.softmax_cross_entropy(
            onehot_labels=y_onehot, logits=logits)

    optimizer = tf.train.GradientDescentOptimizer(
            learning_rate=0.001)

    train_op = optimizer.minimize(loss=cost)

    init_op = tf.global_variables_initializer()




def create_batch_generator(X, y, batch_size=128, shuffle=False):
    X_copy = np.array(X)
    y_copy = np.array(y)
    
    if shuffle:
        data = np.column_stack((X_copy, y_copy))
        np.random.shuffle(data)
        X_copy = data[:, :-1]
        y_copy = data[:, -1].astype(int)
    
    for i in range(0, X.shape[0], batch_size):
        yield (X_copy[i:i+batch_size, :], y_copy[i:i+batch_size])




## tworzy sesję uruchamiajacą graf
sess =  tf.Session(graph=g)
## uruchamia operację inicjowania zmiennych
sess.run(init_op)

## 50 epok uczenia:
training_costs = []
for epoch in range(50):
    training_loss = []
    batch_generator = create_batch_generator(
            X_train_centered, y_train, 
            batch_size=64)
    for batch_X, batch_y in batch_generator:
        ## przygotowuje słownik dostarczający dane do naszej sieci:
        feed = {tf_x:batch_X, tf_y:batch_y}
        _, batch_cost = sess.run([train_op, cost],
                                 feed_dict=feed)
        training_costs.append(batch_cost)
    print(' -- Epoka %2d  '
          'Śr. strata w trakcie uczenia: %.4f' % (
              epoch+1, np.mean(training_costs)
    ))




## uzyskuje prognozy wobec zestawu testowego:
feed = {tf_x : X_test_centered}
y_pred = sess.run(predictions['classes'], 
                  feed_dict=feed)
 
print('Dokładność dla podzbioru testowego: %.2f%%' % (
      100*np.sum(y_pred == y_test)/y_test.shape[0]))


# ### Projektowanie wielowarstwowej sieci neuronowej za pomocą interfejsu Keras



X_train, y_train = load_mnist('./', kind='train')
print('Rzędy: %d, Kolumny: %d' %(X_train.shape[0], 
                                 X_train.shape[1]))
X_test, y_test = load_mnist('./', kind='t10k')
print('Rzędy: %d, Kolumny: %d' %(X_test.shape[0], 
                                 X_test.shape[1]))

## środkowanie do średniej i normalizacja:
mean_vals = np.mean(X_train, axis=0)
std_val = np.std(X_train)

X_train_centered = (X_train - mean_vals)/std_val
X_test_centered = (X_test - mean_vals)/std_val
 
del X_train, X_test
 
print(X_train_centered.shape, y_train.shape)

print(X_test_centered.shape, y_test.shape)




#import tensorflow.keras as keras

# UWAGA:
# ================================================
# Jeżeli masz zainstalowaą wersję 1.3 modułu TensorFlow v1.3,
# możesz wykorzystać inyterfejs keras API
# importując go z modułu contrib:
# `import tensorflow.contrib.keras as keras`

np.random.seed(123)
tf.set_random_seed(123)




y_train_onehot = keras.utils.to_categorical(y_train)
 
print('Pierwsze trzy etykiety: ', y_train[:3])
print('\nPierwsze trzy etykiety (zakodowane „gorącojedynkowo”):\n', y_train_onehot[:3])




model = keras.models.Sequential()

model.add(
    keras.layers.Dense(
        units=50,    
        input_dim=X_train_centered.shape[1],
        kernel_initializer='glorot_uniform',
        bias_initializer='zeros',
        activation='tanh'))

model.add(
    keras.layers.Dense(
        units=50,    
        input_dim=50,
        kernel_initializer='glorot_uniform',
        bias_initializer='zeros',
        activation='tanh'))

model.add(
    keras.layers.Dense(
        units=y_train_onehot.shape[1],    
        input_dim=50,
        kernel_initializer='glorot_uniform',
        bias_initializer='zeros',
        activation='softmax'))


sgd_optimizer = keras.optimizers.SGD(
        lr=0.001, decay=1e-7, momentum=.9)

model.compile(optimizer=sgd_optimizer,
              loss='categorical_crossentropy')




history = model.fit(X_train_centered, y_train_onehot,
                    batch_size=64, epochs=50,
                    verbose=1,
                    validation_split=0.1)




y_train_pred = model.predict_classes(X_train_centered, verbose=0)
print('Pierwsze trzy prognozy: ', y_train_pred[:3])




y_train_pred = model.predict_classes(X_train_centered, 
                                     verbose=0)
correct_preds = np.sum(y_train == y_train_pred, axis=0) 
train_acc = correct_preds / y_train.shape[0]

print('Pierwsze trzy prognozy: ', y_train_pred[:3])
print('Dokładność wobec zbioru uczącego: %.2f%%' % (train_acc * 100))




y_test_pred = model.predict_classes(X_test_centered, 
                                    verbose=0)

correct_preds = np.sum(y_test == y_test_pred, axis=0) 
test_acc = correct_preds / y_test.shape[0]
print('Dokładność wobec zbioru testowego: %.2f%%' % (test_acc * 100))


# ## Dobór funkcji aktywacji dla wielowarstwowych sieci neuronowych

# ### Funkcja logistyczna — powtórzenie




X = np.array([1, 1.4, 2.5]) ## first value must be 1
w = np.array([0.4, 0.3, 0.5])

def net_input(X, w):
    return np.dot(X, w)

def logistic(z):
    return 1.0 / (1.0 + np.exp(-z))

def logistic_activation(X, w):
    z = net_input(X, w)
    return logistic(z)

print('P(y=1|x) = %.3f' % logistic_activation(X, w))




# W : tablica, wymiary = [n_jednostek_wyjściowych,  n_jednostek_ukrytych+1]
#     zwróć uwagę, że pierwsza kolumna zawiera jednostki obciążenia

W = np.array([[1.1, 1.2, 0.8, 0.4],
              [0.2, 0.4, 1.0, 0.2],
              [0.6, 1.5, 1.2, 0.7]])

# A : tablica, wymiary = [n_ukrytych+1, n_próbek]
#     zwróć uwagę, że pierwsza kolumna w tej tablicy musi być równa 1

A = np.array([[1, 0.1, 0.4, 0.6]])

Z = np.dot(W, A[0])
y_probas = logistic(Z)

print('Pobudzenie całkowite: \n', Z)

print('Jednostki wyjściowe:\n', y_probas)




y_class = np.argmax(Z, axis=0)
print('Przewidywana etykieta klas: %d' % y_class)


# ### Szacowanie prawdopodobieństw przynależności do klas w klasyfikacji wieloklasowej za pomocą funkcji softmax



def softmax(z):
    return np.exp(z) / np.sum(np.exp(z))

y_probas = softmax(Z)
print('Prawdopodobieństwa:\n', y_probas)




np.sum(y_probas)


# ### Rozszerzanie zakresu wartości wyjściowych za pomocą funkcji tangensa hiperbolicznego




def tanh(z):
    e_p = np.exp(z)
    e_m = np.exp(-z)
    return (e_p - e_m) / (e_p + e_m)

z = np.arange(-5, 5, 0.005)
log_act = logistic(z)
tanh_act = tanh(z)

plt.ylim([-1.5, 1.5])
plt.xlabel('Pobudzenie całkowite $z$')
plt.ylabel('Aktywacja $\phi(z)$')
plt.axhline(1, color='black', linestyle=':')
plt.axhline(0.5, color='black', linestyle=':')
plt.axhline(0, color='black', linestyle=':')
plt.axhline(-0.5, color='black', linestyle=':')
plt.axhline(-1, color='black', linestyle=':')

plt.plot(z, tanh_act,
         linewidth=3, linestyle='--',
         label='Funkcja tanh')

plt.plot(z, log_act,
         linewidth=3,
         label='Funkcja logistyczna')
plt.legend(loc='lower right')
plt.tight_layout()
#plt.savefig('rysunki/13_03.png')
plt.show()


# ### Aktywacja za pomocą prostowanej jednostki liniowej





# ## Podsumowanie

# ...

# ---
# 
# Czytelnicy mogą zignorować poniższą komórkę.




