## Python. Uczenie maszynowe (wyd. 2.) - repozytorium kodu

[![Wersja](https://travis-ci.com/rasbt/python-machine-learning-book-2nd-edition.svg?token=zvSsJVLJFKzB2yqaeKN1&branch=master)](https://travis-ci.com/rasbt/python-machine-learning-book-2nd-edition)
![Python 3.6](https://img.shields.io/badge/Python-3.6-blue.svg)
![Licencja](https://img.shields.io/badge/Code%20License-MIT-blue.svg)



**Python. Uczenie maszynowe. Drugie wydanie**  

opublikowane 20 września 2017 roku

Oprawa miękka: 622 stron  
Wydawca: Packt Publishing  
Język: angielski

ISBN-10: 1787125939  
ISBN-13: 978-1787125933  
Kindle ASIN: B0742K7HYF  

[<img src="./rysunki/okładka_1.jpg" width="348">](https://www.amazon.com/Python-Machine-Learning-scikit-learn-TensorFlow/dp/1787125939)


## Odnośniki

- [Wydawnictwo Helion](https://helion.pl/ksiazki/python-uczenie-maszynowe-sebastian-raschka,pythum.htm#format/d)
- [Wydawnictwo Packt](https://www.packtpub.com/big-data-and-business-intelligence/python-machine-learning-second-edition)



## Spis treści i notatników

**Przydatne informacje dotyczące instalacji i konfiguracji znajdziesz w [pliku CZYTAJ.md umieszczonym w rozdziale 1.](kod/r01/CZYTAJ.md)**

Aby uzyskać dostęp do kodu opisanego w danym rozdziale, kliknij odnośnik `otwórz katalog` umieszczony przy nagłówku tego rozdziału, dzięki czemu przejdziesz do podkatalogów znajdujących się wewnątrz folderu [kod/](kod/).

Ponadto podkatalogi umieszczone w folderze [kod/](kod/) zawierają również pliki skryptów .py, utworzone z notatników Jupyter. Gorąco jednak zalecam pracę z tymi notatnikami w miarę możliwości. Nie tylko zawierają one rysunki i spis treści ułatwiający nawigację, lecz także umożliwiają realizację fragmentów kodu krok po kroku, co -- moim zdaniem -- znacznie ułatwia naukę.

**Zwróć uwagę, że przykładowy kod stanowi uzupełnienie książki, które stworzyłem dla Twojej wygody; notatniki te mogą być nieprzydatne bez zapoznania się ze wzorami i tekstem opisowym.**   


1. Umożliwianie komputerom uczenia się z danych [[otwórz katalog](./kod/r01)]  
2. Trenowanie prostych algorytmów uczenia maszynowego w celach klasyfikacji [[otwórz katalog](./kod/r02)]  
3. Stosowanie klasyfikatorów uczenia maszynowego za pomocą biblioteki scikit-learn [[otwórz katalog](./kod/r03)]  
4. Tworzenie dobrych zbiorów uczących — wstępne przetwarzanie danych [[otwórz katalog](./kod/r04)]  
5. Kompresja danych poprzez redukcję wymiarowości [[otwórz katalog](./kod/r05)]  
6. Najlepsze metody oceny modelu i strojenie parametryczne [[open dir](./kod/r06)] 
7. Łączenie różnych modeli w celu uczenia zespołowego [[otwórz katalog](./kod/r07)] 
8. Wykorzystywanie uczenia maszynowego w analizie sentymentów [[otwórz katalog](./kod/r08)]  
9. Wdrażanie modelu uczenia maszynowego do aplikacji sieciowej [[otwórz katalog](./kod/r09)]  
10. Przewidywanie ciągłych zmiennych docelowych za pomocą analizy regresywnej [[otwórz katalog](./kod/r10)]  
11. Praca z nieoznakowanymi danymi — analiza skupień [[otwórz katalog](./kod/r11)]  
12. Implementowanie wielowarstwowej, sztucznej sieci neuronowej od podstaw [[otwórz katalog](./kod/r12)]  
13. Równoległe przetwarzanie sieci neuronowych za pomocą biblioteki TensorFlow [[otwórz katalog](./kod/r13)]  
14. Czas na szczegóły — mechanizm działania biblioteki TensorFlow [[otwórz katalog](./kod/r14)]  
15. Klasyfikowanie obrazów za pomocą splotowych sieci neuronowych [[otwórz katalog](./kod/r15)]  
16. Modelowanie danych sekwencyjnych za pomocą rekurencyjnych sieci neuronowych [[otwórz katalog](./kod/r16)]  

### Co nowego w wydaniu drugim?

> Oh, dodaliśmy albo zaktualizowaliśmy tyle rzeczy; od czego zacząć? Jednym z moich priorytetów było usunięcie wszystkich paskudnych literówek, które pojawiły się na etapie składu lub które po prostu przeoczyłem. Szczerze doceniam wszelkie uwagi przysyłane przez Czytelników! Dodatkowo wysłuchałem wszystkich głosów na temat fragmentów, które mogły być nieco zagmatwane lub niejasne; zmodyfikowałem ich treść i wstawiłem dodatkowe wyjaśnienia. Specjalne podziękowania kieruję do doskonałych redaktorów drugiego wydania, którzy bardzo mi pomogli!

> Poza tym rysunki i wykresy stały się znacznie ładniejsze. Czytelnikom podobała się ich treść, ale niektóre osoby krytykowały styl i wygląd nieco za bardzo przypominające prezentacje typu PowerPoint. Dlatego postanowiłem nieco przerobić rysunki i dobrałem, mam nadzieję, przyjemniejsze dla oka czcionki i barwy. Do tego wykresy danych są teraz znacznie bardziej eleganckie dzięki zespołowi twórców biblioteki matplotlib, którzy włożyli mnóstwo pracy w jej drugą wersję i jej nowe motywy stylistyczne.

> Oprócz zmian natury kosmetycznej wprowadziliśmy tu i tam nowe fragmenty. Wśród nich znajdziesz, między innymi, ustęp poświęcony niewyważonym zestawowm danych, którego brakowało kilku Czytelnikom w poprzednim wydaniu, a także alokacji ukrytej zmiennej Dirichleta.

> Czas i świat inżynierii oprogramowania poszły naprzód od momentu wydania pierwszej edycji książki we wrześniu 2015 roku, dlatego postanowiliśmy zastąpić wprowadzenie do uczenia głębokiego za pomocą biblioteki Theano. Bez obaw, nie usunęliśmy go, lecz znacznie zmodyfikowaliśmy i teraz bazuje na bibliotece TensorFlow, która od chwili wydania przez firmę Google w grudniu 2015 roku stała się kluczowym narzędziem w moim przyborniku. 
Oprócz tego przerobionego wprowadzenia do uczenia głębokiego największą zmianą w tym wydaniu są trzy nowe rozdziały koncentrujące się na zastosowaniach uczenia głębokiego: szczegółowa analiza mechanizmów działania biblioteki TensorFlow, wprowadzenie do splotowych sieci neuronowych służących do klasyfikowania obrazów, a także wstęp do rekurencyjnych sieci neuronowych umożliwiających przetwarzanie języka naturalnego. Oczywiście, rozdziały te pozostają zgodne z duchem całej książki i zawierają nie tylko instrukcje praktyczne wraz z przykładami, lecz również znajdziesz w nich podstawy teorii matematycznej kryjącej się za omawianymi koncepcjami, co stanowi element niezbędny do zrozumienia działania modeli uczenia głębokiego.

[ [Fragment z wywiadu "Machine Learning can be useful in almost every problem domain:" przeprowadzonego z autorem książki - Sebastianem Raschka](https://www.packtpub.com/books/content/machine-learning-useful-every-problem-domain-interview-sebastian-raschka/) ]


--- 

<br>
<br>

Raschka, Sebastian i Vahid Mirjalili. *Python. Uczenie maszynowe. Wydanie drugie*. Packt Publishing, 2017.

    @book{RaschkaMirjalili2017,  
    address = {Birmingham, UK},  
    author = {Raschka, Sebastian and Mirjalili, Vahid},  
    edition = {2},  
    isbn = {978-1787125933},  
    keywords = {Clustering,Data Science,Deep Learning,  
                Machine Learning,Neural Networks,Programming,  
                Supervised Learning},  
    publisher = {Packt Publishing},  
    title = {{Python Machine Learning, 2nd Ed.}},  
    year = {2017}  
    }

# Przekłady

### Niemiecki

- ISBN-10: 3958457339
- ISBN-13: 978-3958457331
- [Amazon.de](https://www.amazon.de/Machine-Learning-Python-Scikit-Learn-TensorFlow/dp/3958457339/ref=tmm_pap_swatch_0?_encoding=UTF8&qid=1513601461&sr=8-5)
- [Wydawca](https://mitp.de/IT-WEB/Programmierung/Machine-Learning-mit-Python-oxid.html)

![](rysunki/okładka-niemiecka.jpg)