## Zasoby pomagające skonfigurować środowisko robocze

- [Instrukcje konfigurowania środowiska Python i aplikacji Jupyter Notebook](./r01/CZYTAJ.md)  

- [Krótkie wprowadzenie/przypomnienie opisujące biblitekę NumPy](https://sebastianraschka.com/pdf/books/dlb/appendix_f_numpy-intro.pdf) zawierające wszystkie niezbędne informacje (a nawet więcej)

## Spis treści i notatników

**Przydatne informacje dotyczące instalacji i konfiguracji znajdziesz w [pliku CZYTAJ.md umieszczonym w rozdziale 1.](kod/r01/CZYTAJ.md)**

Aby uzyskać dostęp do kodu opisanego w danym rozdziale, kliknij odnośnik `otwórz katalog` umieszczony przy nagłówku tego rozdziału, dzięki czemu przejdziesz do podkatalogów znajdujących się wewnątrz folderu [kod/](kod/).

Ponadto podkatalogi umieszczone w folderze [kod/](kod/) zawierają również pliki skryptów .py, utworzone z notatników Jupyter. Gorąco jednak zalecam pracę z tymi notatnikami w miarę możliwości. Nie tylko zawierają one rysunki i spis treści ułatwiający nawigację, lecz także umożliwiają realizację fragmentów kodu krok po kroku, co -- moim zdaniem -- znacznie ułatwia naukę.

**Zwróć uwagę, że przykładowy kod stanowi uzupełnienie książki, które stworzyłem dla Twojej wygody; notatniki te mogą być nieprzydatne bez zapoznania się ze wzorami i tekstem opisowym.**   


1. Umożliwianie komputerom uczenia się z danych [[otwórz katalog](./kod/r01)]  
2. Trenowanie prostych algorytmów uczenia maszynowego w celach klasyfikacji [[otwórz katalog](./kod/r02)]  
3. Stosowanie klasyfikatorów uczenia maszynowego za pomocą biblioteki scikit-learn [[otwórz katalog](./kod/r03)]  
4. Tworzenie dobrych zbiorów uczących — wstępne przetwarzanie danych [[otwórz katalog](./kod/r04)]  
5. Kompresja danych poprzez redukcję wymiarowości [[otwórz katalog](./kod/r05)]  
6. Najlepsze metody oceny modelu i strojenie parametryczne [[open dir](./kod/r06)] 
7. Łączenie różnych modeli w celu uczenia zespołowego [[otwórz katalog](./kod/r07)] 
8. Wykorzystywanie uczenia maszynowego w analizie sentymentów [[otwórz katalog](./kod/r08)]  
9. Wdrażanie modelu uczenia maszynowego do aplikacji sieciowej [[otwórz katalog](./kod/r09)]  
10. Przewidywanie ciągłych zmiennych docelowych za pomocą analizy regresywnej [[otwórz katalog](./kod/r10)]  
11. Praca z nieoznakowanymi danymi — analiza skupień [[otwórz katalog](./kod/r11)]  
12. Implementowanie wielowarstwowej, sztucznej sieci neuronowej od podstaw [[otwórz katalog](./kod/r12)]  
13. Równoległe przetwarzanie sieci neuronowych za pomocą biblioteki TensorFlow [[otwórz katalog](./kod/r13)]  
14. Czas na szczegóły — mechanizm działania biblioteki TensorFlow [[otwórz katalog](./kod/r14)]  
15. Klasyfikowanie obrazów za pomocą splotowych sieci neuronowych [[otwórz katalog](./kod/r15)]  
16. Modelowanie danych sekwencyjnych za pomocą rekurencyjnych sieci neuronowych [[otwórz katalog](./kod/r16)] 





## Kontakt

Chętnie odpowiem na wszelkie pytania! Napisz do mnie na [adres](mailto:mail@sebastianraschka.com)
lub zadaj pytanie na [liście mailingowej Google Groups](https://groups.google.com/forum/#!forum/python-machine-learning-book).

Jeżeli chcesz być na bieżąco, mam całkiem aktywne konto na Twitterze ([@rasbt](https://twitter.com/rasbt)), poświęcone w całości analizie danych i uczeniu maszynowemu. Prowadzę również [blog](http://sebastianraschka.com/articles.html), w którym zamieszczam informacje na temat wszystkiego, co mnie w danym momencie pasjonuje.
