import unittest
import os
import subprocess
import sys
import logging


LOG_FORMAT = '[%(asctime)s %(levelname)s] %(message)s'
LOGGER = logging.getLogger(__file__)


def run_ipynb(path):

    nb_dir = os.path.dirname(path)
    nb_path = os.path.basename(path)
    orig_dir = os.getcwd()
    os.chdir(nb_dir)

    if (sys.version_info >= (3, 0)):
        kernel_name = 'python3'
    else:
        kernel_name = 'python2'
    #  error_cells = []

    args = ["jupyter", "nbconvert",
            "--execute", "--inplace",
            "--debug",
            "--ExecutePreprocessor.timeout=5000",
            "--ExecutePreprocessor.kernel_name=%s" % kernel_name,
            nb_path]

    if (sys.version_info >= (3, 0)):
        try:
            subprocess.check_output(args)
        except TimeoutError:
            sys.stderr.write('%s przekroczonego limitu czasu\n' % path)
            sys.stderr.flush()

    else:
        subprocess.check_output(args)

    os.chdir(orig_dir)


class TestNotebooks(unittest.TestCase):

    def test_ch01(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r01/r01.ipynb'))

    def test_ch02(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r02/r02.ipynb'))

    def test_ch03(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r03/r03.ipynb'))

    def test_ch04(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r04/r04.ipynb'))

    def test_ch05(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r05/r05.ipynb'))

    def test_ch06(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r06/r06.ipynb'))

    def test_ch07(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r07/r07.ipynb'))

    def test_ch08(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))

        # uruchamiaj jedynie w środowisku Py3, z powodu obsługi formatu unicode w środowisku Py2
        if (sys.version_info >= (3, 0)):
            run_ipynb(os.path.join(this_dir,
                                   '../r08/r08.ipynb'))

    def test_ch09(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))

        # uruchamiaj jedynie w środowisku Py3, z powodu pewnych plików serializacji w środowisku Py2
        if (sys.version_info >= (3, 0)):
            run_ipynb(os.path.join(this_dir, '../r09/r09.ipynb'))
        else:
            pass

    def test_ch10(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r10/r10.ipynb'))

    def test_ch11(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r11/r11.ipynb'))

    def test_ch12(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r12/r12.ipynb'))

    def test_ch13(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r13/r13.ipynb'))

    def test_ch14(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r14/r14.ipynb'))

    def test_ch15(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        run_ipynb(os.path.join(this_dir,
                               '../r15/r15.ipynb'))

    def test_ch16(self):
        this_dir = os.path.dirname(os.path.abspath(__file__))
        # uruchamiaj jedynie w środowisku Py3, z powodu obsługi formatu unicode w środowisku Py2
        if (sys.version_info >= (3, 0)):
            run_ipynb(os.path.join(this_dir,
                                   '../r16/r16.ipynb'))


if __name__ == '__main__':
    unittest.main()
