Python. Uczenie maszynowe - kod źródłowy


##  Rozdział 13. Równoległe przetwarzanie sieci neuronowych za pomocą biblioteki TensorFlow

### Spis treści

- Biblioteka TensorFlow a skuteczność uczenia
  - Czym jest biblioteka TensorFlow?
  - W jaki sposób będziemy poznawać bibliotekę TensorFlow?
  - Pierwsze kroki z biblioteką TensorFlow
  - Praca ze strukturami tablicowymi
  - Tworzenie prostego modelu za pomocą podstawowego interfejsu TensorFlow
- Skuteczne uczenie sieci neuronowych za pomocą wyspecjalizowanych interfejsów biblioteki TensorFlow
  - Tworzenie wielowarstwowych sieci neuronowych za pomocą interfejsu Layers
  - Projektowanie wielowarstwowej sieci neuronowej za pomocą interfejsu Keras
- Dobór funkcji aktywacji dla wielowarstwowych sieci neuronowych
  - Funkcja logistyczna — powtórzenie
  - Szacowanie prawdopodobieństw przynależności do klas w klasyfikacji wieloklasowej za pomocą funkcji softmax
  - Rozszerzanie zakresu wartości wyjściowych za pomocą funkcji tangensa hiperbolicznego
  - Aktywacja za pomocą prostowanej jednostki liniowej (ReLU)
- Podsumowanie

### Informacje na temat korzystania z kodu źródłowego

Zalecanym sposobem przeglądania kodu źródłowego opisywanego w książce jest aplikacja Jupyter Notebook (pliki w formacie `.ipynb`). W ten sposób jesteś w stanie realizować poszczególne fragmenty kodu krok po kroku, a wszystkie wyniki (łącznie z wykresami i rysunkami) są wygofnie generowane w jednym dokumencie.

![](rysunki/jupyter-przykład-1.png)



Konfiguracja aplikacji Jupyter Notebook jest naprawdę prosta: jeżeli korzystasz z platformy Anaconda Python, wystarczy wpisać w terminalu poniższą komendę, aby zainstalować wspomniany program:

    conda install jupyter notebook

Teraz możesz uruchomić aplikację Jupyter Notebook w następujący sposób:

    jupyter notebook

Zostanie otwarte nowe okno w Twojej przeglądarce, w którym możesz przejść do katalogu docelowego zawierającego plik `.ipynb`, który zamierzasz otworzyć.

**Dodatkowe instrukcje dotyczące instalacji i konfiguracji znajdziesz w [pliku CZYTAJ.md w katalogu poświęconym rozdziałowi 1.](../r01/CZYTAJ.md)**.


Oprócz samego kodu źródłowego, dołączyłem również w każdym notatniku Jupyter spis treści, a także nagłówki sekcji, które są spójne z treścią książki. Ponadto umieściłem również występujące w niej rysunki, dzięki czemu powinno Ci się łatwiej przeglądać zawartość plików i pracować z kodem.

![](rysunki/jupyter-przykład-2.png)


Tworząc te notatniki przyświecał mi cel jak największego ułatwienia Tobie ich przeglądania (i tworzenia kodu)! Jeśli jednak nie zamierzasz korzystać z aplikacji Jupyter Notebook, przekonwertowałem te notatniki również do postaci standardowych plików skryptoiwych Pythona (w formacie `.py`), które można przeglądać i edytować w dowolnym edytorze tekstu. 