# -*- coding: utf-8 -*-
from xml.dom import minidom

Station1 = ['Pentium M', '512MB']
Station2 = ['Pentium Core 2', '1024MB']
Station3 = ['Pentium Core Duo', '1024MB']
StationList = [Station1, Station2, Station3]

# Utworzenie obiektu DOM
DOMimpl = minidom.getDOMImplementation()

# Utworzenie dokumentu
xmldoc = DOMimpl.createDocument(None, "Workstations", None)
doc_root = xmldoc.documentElement

# Dodanie węzłów
for station in StationList:
   # Utworzenie węzła
   node = xmldoc.createElement("Computer")

   element = xmldoc.createElement('Processor')
   element.appendChild(xmldoc.createTextNode(station[0]))
   node.appendChild(element)

   element = xmldoc.createElement('Memory')
   element.appendChild(xmldoc.createTextNode(station[1]))
   node.appendChild(element)

   # Dodanie węzła
   doc_root.appendChild(node)

print "\nWęzły\n==================="
nodeList = doc_root.childNodes
for node in nodeList:
   print node.toprettyxml()

# Zapisanie dokumentu
file = open("stations.xml", 'w')
file.write(xmldoc.toxml("utf-8"))
