# -*- coding: utf-8 -*-
import HTMLParser
import urllib
import sys

# Zdefiniowanie analizatora składniowego HTML
class parseAttrs(HTMLParser.HTMLParser):
   def init_parser (self):
      self.pieces = []

   def handle_starttag(self, tag, attrs):
      fixedAttrs = ""
      #for name,value in attrs:
      for name, value in attrs:
         fixedAttrs += "%s=\"%s\" " % (name, value)
      self.pieces.append("<%s %s>" % (tag, fixedAttrs))

   def handle_charref(self, name):
      self.pieces.append("&#%s;" % (name))

   def handle_endtag(self, tag):
      self.pieces.append("</%s>" % (tag))

   def handle_entityref(self, ref):
      self.pieces.append("&%s" % (ref))

   def handle_data(self, text):
      self.pieces.append(text)

   def handle_comment(self, text):
      self.pieces.append("<!--%s-->" % (text))

   def handle_pi(self, text):
      self.pieces.append("<?%s>" % (text))

   def handle_decl(self, text):
      self.pieces.append("<!%s>" % (text))

   def parsed (self):
      return "".join(self.pieces)

# Utworzenie obiektu analizatora składniowego HTML
attrParser = parseAttrs()

# Inicjalizacja danych analizatora składniowego
attrParser.init_parser()

# Dostarczenie pliku HTML do analizatora składniowego
attrParser.feed(urllib.urlopen("test2.html").read())

# Wyświetlenie oryginalnej zawartości pliku
print "Oryginalny plik\n========================"
print open("test2.html").read()

# Wyświetlenie przetworzonego pliku
print "Przetworzony plik\n========================"
print attrParser.parsed()

attrParser.close()