# -*- coding: utf-8 -*-
import os
path = "/books/python"
pattern = "*.py;*.doc"

# Wydrukowanie plików, które odpoiwiadają wybranym rozszerzeniom
def printFiles(dirList, spaceCount, typeList):
   for file in dirList:
      for ext in typeList:
         if file.endswith(ext):
            print "/".rjust(spaceCount+1) + file
            break

# Wydrukowanie każdego podkatalogu
def printDirectory(dirEntry, typeList):
   print dirEntry[0] + "/"
   printFiles(dirEntry[2], len(dirEntry[0]), typeList)

# Konwersja łańcucha znaków wzorca na listę rozszerzeń plików
extList = []
for ext in pattern.split(";"):
   extList.append(ext.lstrip("*"))

# Przejście drzewa katalogów w celu wydrukowania plików
for directory in os.walk(path):
   printDirectory(directory, extList)
