"""
reloadall3.py: przechodnie przeładowanie zagnieżdżonych modułów.
Alternatywna wersja: brak rekurencji, jawny stos.
"""

import types
from reloadall import status, tryreload, tester

def transitive_reload(objects, visited):
    while objects:
        next = objects.pop()                        # Usuń kolejny element z końca listy
        if (type(next) == types.ModuleType          # Czy to jest obiekt modułu?
            and next not in visited):               # Jeszcze nieprzeładowany?
            status(next)                            # Przeładuj to, dodaj atrybuty
            tryreload(next)
            visited.add(next)
            objects.extend(next.__dict__.values())

def reload_all(*args):
    transitive_reload(list(args), set())

if __name__ == '__main__':
    tester(reload_all, 'reloadall3')                # Autotest: przeładować swój moduł czy argument?

