"""
Uruchom pybench.py, aby zmierzyć czas działania jednego lub więcej interpreterów Pythona na różnych ciągach kodu. Użyj argumentów wiersza poleceń (które pojawiają się w sys.argv), aby wybrać tryby:

<python> pybench_tests.py: mierzy czas działania tylko hostującego Pythona w całym kodzie wymienionym poniżej w stmts.
python3 pybench_tests.py -a: mierzy czas wszystkich stmts we wszystkich interpreterach Pythona, których ścieżki są wymienione poniżej.
python3 pybench_tests.py -a -t: to samo co -a, ale dodatkowo w pełni śledzi wiersze poleceń.

Edytuj stmts, aby zmienić testowany kod oraz edytuj listę pythons, aby podać ścieżki do wykonywalnych plików Pythona, które mają być testowane w trybie -a. Aby znaleźć ścieżkę Pythona, uruchom sesję REPL, wykonaj "import sys" i sprawdź "sys.executable".
"""

import pybench, sys

pythons = [
    '/Library/Frameworks/Python.framework/Versions/3.12/bin/python3',
    '/Users/me/Downloads/pypy3.10-v7.3.16-macos_x86_64/bin/pypy3',
]

stmts = [
# Iteracje
    (0, 0, '[x ** 2 for x in range(1000)]'),                        # (num,rpt,stmt)
    (0, 0, 'res=[]\nfor x in range(1000): res.append(x ** 2)'),     # \n=multistmt
    (0, 0, 'list(map(lambda x: x ** 2, range(1000)))'),             # \n\t=indent
    (0, 0, 'list(x ** 2 for x in range(1000))'),
# Operacje na łańcuchach znaków
    (0, 0, "s = 'haker' * 2500\nx = [s[i] for i in range(10_000)]"),
    (0, 0, "s = '?'\nfor i in range(10_000): s += '?'"),            # PyPy przegrywa!
]

tracecmd = '-t' in sys.argv                           # -t: śledzenie wiersza poleceń?
pythons  = pythons if '-a' in sys.argv else None      # -a: wszystkie wersje z listy czy tylko bieżąca?
pybench.runner(stmts, pythons, tracecmd)              # Mierzenie czasu wszystkich instrukcji z podanymi wersjami Pythona
