"Rozszerzenie klasy za pomocą dekoratora"

def triple(obj):
    return obj.value * 3

def concat(obj):
    return obj.value + 'Kod!'

def extender(aClass):
    aClass.triple = triple                   # Zarządza klasą, a nie instancją
    aClass.concat = concat                   # Odpowiednik __call__ metaklasy
    return aClass

@extender
class Client1:                               # Client1 = Extender(Client1)
    def __init__(self, value):               # Dowiązane ponownie na końcu instrukcji class
        self.value = value
    def double(self):
        return self.value * 2

@extender
class Client2:
    value = 'grok'

X = Client1('hakować')                                       
print(X.double(), X.triple(), X.concat(), sep='\n')

Y = Client2()                                             
print(Y.triple(), Y.concat(), sep='\n')

