class CardHolder:
    acctlen = 8                                  # Dane klasy
    retireage = 62.5

    def __init__(self, acct, name, age, addr):
        self.acct = acct                         # Dane instancji
        self.name = name                         # Te także wywołują metodę __setattr__
        self.age  = age                          # Zmiana nazwy __acct nie jest konieczna: nazwa jest sprawdzana
        self.addr = addr                         # Atrybut addr nie jest zarządzany
                                                 # Atrybut remain nie ma danych
    def __getattr__(self, name):
        match name:
            case 'acct':                               # Przy pobraniu niezdefiniowanego atrybutu
                return self._acct[:-3] + '***'         # Atrybuty name, age, addr są zdefiniowane
            case 'remain':
                return self.retireage - self.age       # Nie wywołuje__getattr__
            case _:
                raise AttributeError(name)

    def __setattr__(self, name, value):
        match name:
            case 'name':                                 # Dla wszystkich przypisań do atrybutów
                value = value.lower().replace(' ', '_')  # Atrybut addr przechowany w sposób bezpośredni
            case 'age':                                  # Zmiana nazwy acct na _acct
                if value < 0 or value > 150:
                    raise ValueError('niepoprawny wiek')
            case 'acct':
                name  = '_acct'
                value = value.replace('-', '')
                if len(value) != self.acctlen:
                    raise TypeError('niepoprawny numer konta')
            case 'remain':
                raise TypeError('nie można ustawić remain')
        self.__dict__[name] = value                      # Uniknięcie zapętlenia

